/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexErrorAdapter;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.service.BittrexAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.MoneroWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsZero;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BittrexAccountService
extends BittrexAccountServiceRaw
implements AccountService {
    public BittrexAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            return new AccountInfo(new Wallet[]{BittrexAdapters.adaptWallet(this.getBittrexBalances())});
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return this.withdraw(currency.getCurrencyCode(), amount, address, null);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams defaultParams = (RippleWithdrawFundsParams)params;
                return this.withdraw(defaultParams.getCurrency().getCurrencyCode(), defaultParams.getAmount(), defaultParams.getAddress(), defaultParams.getTag());
            }
            if (params instanceof MoneroWithdrawFundsParams) {
                MoneroWithdrawFundsParams moneroWithdrawFundsParams = (MoneroWithdrawFundsParams)params;
                return this.withdraw(moneroWithdrawFundsParams.getCurrency().getCurrencyCode(), moneroWithdrawFundsParams.getAmount(), moneroWithdrawFundsParams.getAddress(), moneroWithdrawFundsParams.getPaymentId());
            }
            if (params instanceof DefaultWithdrawFundsParams) {
                DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
                return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
            }
            throw new IllegalStateException("Don't know how to withdraw: " + params);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        try {
            return this.getBittrexDepositAddress(currency.toString());
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return TradeHistoryParamsZero.PARAMS_ZERO;
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            ArrayList<FundingRecord> res = new ArrayList<FundingRecord>();
            Currency currency = null;
            if (params instanceof TradeHistoryParamCurrency) {
                currency = ((TradeHistoryParamCurrency)params).getCurrency();
            }
            List<BittrexDepositHistory> depositsHistory = this.getDepositsHistory(currency);
            for (BittrexDepositHistory depositHistory : depositsHistory) {
                res.add(new FundingRecord(depositHistory.getCryptoAddress(), depositHistory.getLastUpdated(), Currency.getInstance((String)depositHistory.getCurrency()), depositHistory.getAmount(), String.valueOf(depositHistory.getId()), depositHistory.getTxId(), FundingRecord.Type.DEPOSIT, FundingRecord.Status.COMPLETE, null, null, null));
            }
            List<BittrexWithdrawalHistory> withdrawalsHistory = this.getWithdrawalsHistory(currency);
            for (BittrexWithdrawalHistory withdrawalHistory : withdrawalsHistory) {
                FundingRecord.Status status = FundingRecord.Status.COMPLETE;
                if (withdrawalHistory.getCanceled().booleanValue()) {
                    status = FundingRecord.Status.CANCELLED;
                } else if (withdrawalHistory.getInvalidAddress().booleanValue()) {
                    status = FundingRecord.Status.FAILED;
                } else if (!withdrawalHistory.getAuthorized().booleanValue()) {
                    status = FundingRecord.Status.PROCESSING;
                }
                if (withdrawalHistory.getCanceled().booleanValue() || withdrawalHistory.getInvalidAddress().booleanValue()) continue;
                res.add(new FundingRecord(withdrawalHistory.getAddress(), withdrawalHistory.getOpened(), Currency.getInstance((String)withdrawalHistory.getCurrency()), withdrawalHistory.getAmount(), withdrawalHistory.getPaymentUuid(), withdrawalHistory.getTxId(), FundingRecord.Type.WITHDRAWAL, status, null, withdrawalHistory.getTxCost(), null));
            }
            return res;
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }
}

