/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.dto.account.BittrexAccountVolume;
import org.knowm.xchange.bittrex.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.currency.Currency;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexAccountServiceRaw
extends BittrexBaseService {
    public BittrexAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<BittrexBalance> getBittrexBalances() throws IOException {
        return this.bittrexAuthenticated.getBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory()).getResult();
    }

    public BittrexBalance getBittrexBalance(Currency currency) throws IOException {
        return this.bittrexAuthenticated.getBalance(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency == null ? null : currency.getCurrencyCode()).getResult();
    }

    public BittrexOrder getBittrexOrder(String uuid) throws IOException {
        return this.bittrexAuthenticated.getOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uuid).getResult();
    }

    public String getBittrexDepositAddress(String currency) throws IOException {
        return this.bittrexAuthenticated.getdepositaddress(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency).getResult().getAddress();
    }

    public List<BittrexWithdrawalHistory> getWithdrawalsHistory(Currency currency) throws IOException {
        return this.bittrexAuthenticated.getwithdrawalhistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency == null ? null : currency.getCurrencyCode()).getResult();
    }

    public List<BittrexDepositHistory> getDepositsHistory(Currency currency) throws IOException {
        return this.bittrexAuthenticated.getdeposithistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency == null ? null : currency.getCurrencyCode()).getResult();
    }

    public String withdraw(String currencyCode, BigDecimal amount, String address, String paymentId) throws IOException {
        return this.bittrexAuthenticated.withdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currencyCode, amount.toPlainString(), address, paymentId).getResult().getUuid();
    }

    public BittrexAccountVolume getAccountVolume() throws IOException {
        return this.bittrexAuthenticatedV3.getAccountVolume(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreatorV3);
    }
}

