/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexAuthenticatedV3;
import org.knowm.xchange.bittrex.BittrexV2;
import org.knowm.xchange.bittrex.service.BittrexContentDigest;
import org.knowm.xchange.bittrex.service.BittrexDigest;
import org.knowm.xchange.bittrex.service.BittrexDigestV3;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BittrexBaseService
extends BaseExchangeService
implements BaseService {
    protected final String apiKey;
    protected final BittrexAuthenticated bittrexAuthenticated;
    protected final BittrexAuthenticatedV3 bittrexAuthenticatedV3;
    protected final BittrexV2 bittrexV2;
    protected final ParamsDigest contentCreator;
    protected final ParamsDigest signatureCreator;
    protected final BittrexDigestV3 signatureCreatorV3;

    public BittrexBaseService(Exchange exchange) {
        super(exchange);
        this.bittrexAuthenticated = (BittrexAuthenticated)RestProxyFactory.createProxy(BittrexAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.bittrexAuthenticatedV3 = (BittrexAuthenticatedV3)RestProxyFactory.createProxy(BittrexAuthenticatedV3.class, (String)((String)exchange.getExchangeSpecification().getParameter("rest.v3.url")), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.bittrexV2 = (BittrexV2)RestProxyFactory.createProxy(BittrexV2.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BittrexDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
        this.contentCreator = BittrexContentDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
        this.signatureCreatorV3 = BittrexDigestV3.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }
}

