/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class BittrexContentDigest
extends BaseParamsDigest {
    private BittrexContentDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static BittrexContentDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new BittrexContentDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        String content = restInvocation.getRequestBody();
        return DigestUtils.bytesToHex((byte[])md.digest(content.getBytes()));
    }
}

