/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexChartData;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexCurrency;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexDepth;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexV2MarketSummary;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.bittrex.service.BittrexChartDataPeriodType;
import org.knowm.xchange.currency.CurrencyPair;

public class BittrexMarketDataServiceRaw
extends BittrexBaseService {
    public BittrexMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<BittrexCurrency> getBittrexCurrencies() throws IOException {
        return this.bittrexAuthenticated.getCurrencies().getResult();
    }

    public BittrexTicker getBittrexTicker(CurrencyPair currencyPair) throws IOException {
        return this.bittrexAuthenticated.getTicker(BittrexUtils.toPairString(currencyPair)).getResult();
    }

    public List<BittrexSymbol> getBittrexSymbols() throws IOException {
        return this.bittrexAuthenticated.getSymbols().getResult();
    }

    public BittrexMarketSummary getBittrexMarketSummary(String pair) throws IOException {
        List<BittrexMarketSummary> result = this.bittrexAuthenticated.getMarketSummary(pair).getResult();
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<BittrexMarketSummary> getBittrexMarketSummaries() throws IOException {
        return this.bittrexAuthenticated.getMarketSummaries().getResult();
    }

    public BittrexDepth getBittrexOrderBook(String pair, int depth) throws IOException {
        return this.bittrexAuthenticated.getBook(pair, "both", depth).getResult();
    }

    public List<BittrexTrade> getBittrexTrades(String pair) throws IOException {
        return this.bittrexAuthenticated.getTrades(pair).getResult();
    }

    public List<BittrexChartData> getBittrexChartData(CurrencyPair currencyPair, BittrexChartDataPeriodType periodType) throws IOException {
        return this.bittrexV2.getChartData(BittrexUtils.toPairString(currencyPair), periodType.getPeriod()).getResult();
    }

    public List<BittrexChartData> getBittrexLatestTick(CurrencyPair currencyPair, BittrexChartDataPeriodType periodType, Long timeStamp) throws IOException {
        return this.bittrexV2.getLatestTick(BittrexUtils.toPairString(currencyPair), periodType.getPeriod(), timeStamp).getResult();
    }

    public List<BittrexV2MarketSummary> getBittrexV2MarketSummaries() {
        return this.bittrexV2.getMarketSummaries().getResult();
    }
}

