/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.trade.BittrexOpenOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexUserTrade;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexTradeServiceRaw
extends BittrexBaseService {
    public BittrexTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    @Deprecated
    public String placeBittrexMarketOrder(MarketOrder marketOrder) throws IOException {
        return (Order.OrderType.BID.equals((Object)marketOrder.getType()) ? this.bittrexAuthenticated.buymarket(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), BittrexUtils.toPairString(marketOrder.getCurrencyPair()), marketOrder.getOriginalAmount().toPlainString()) : this.bittrexAuthenticated.sellmarket(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), BittrexUtils.toPairString(marketOrder.getCurrencyPair()), marketOrder.getOriginalAmount().toPlainString())).getResult().getUuid();
    }

    public String placeBittrexLimitOrder(LimitOrder limitOrder) throws IOException {
        return (Order.OrderType.BID.equals((Object)limitOrder.getType()) ? this.bittrexAuthenticated.buylimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), BittrexUtils.toPairString(limitOrder.getCurrencyPair()), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString()) : this.bittrexAuthenticated.selllimit(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), BittrexUtils.toPairString(limitOrder.getCurrencyPair()), limitOrder.getOriginalAmount().toPlainString(), limitOrder.getLimitPrice().toPlainString())).getResult().getUuid();
    }

    public boolean cancelBittrexLimitOrder(String uuid) throws IOException {
        this.bittrexAuthenticated.cancel(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uuid);
        return true;
    }

    public List<BittrexOpenOrder> getBittrexOpenOrders(OpenOrdersParams params) throws IOException {
        CurrencyPair currencyPair;
        String ccyPair = null;
        if (params instanceof OpenOrdersParamCurrencyPair && (currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair()) != null) {
            ccyPair = BittrexUtils.toPairString(currencyPair);
        }
        return this.bittrexAuthenticated.openorders(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), ccyPair).getResult();
    }

    public List<BittrexUserTrade> getBittrexTradeHistory(CurrencyPair currencyPair) throws IOException {
        String ccyPair = currencyPair == null ? null : BittrexUtils.toPairString(currencyPair);
        return this.bittrexAuthenticated.getorderhistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), ccyPair).getResult();
    }

    public BittrexOrder getBittrexOrder(String uuid) throws IOException {
        return this.bittrexAuthenticated.getOrder(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), uuid).getResult();
    }
}

