/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.batch.BatchResponse;
import org.knowm.xchange.bittrex.dto.batch.order.BatchOrder;
import org.knowm.xchange.bittrex.dto.batch.order.neworder.TimeInForce;
import org.knowm.xchange.bittrex.dto.trade.BittrexNewOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrders;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import si.mazi.rescu.ParamsDigest;

public class BittrexTradeServiceRaw
extends BittrexBaseService {
    public BittrexTradeServiceRaw(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public String placeBittrexLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeBittrexLimitOrder(limitOrder, TimeInForce.GOOD_TIL_CANCELLED);
    }

    public String placeBittrexLimitOrder(LimitOrder limitOrder, TimeInForce type) throws IOException {
        BittrexNewOrder bittrexNewOrder = new BittrexNewOrder(BittrexUtils.toPairString(limitOrder.getCurrencyPair()), Order.OrderType.BID.equals((Object)limitOrder.getType()) ? "BUY" : "SELL", "LIMIT", limitOrder.getRemainingAmount().toPlainString(), null, limitOrder.getLimitPrice().toPlainString(), type.toString(), null, null);
        return this.bittrexAuthenticated.placeOrder(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, bittrexNewOrder).getId();
    }

    public String placeBittrexMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeBittrexMarketOrder(marketOrder, TimeInForce.IMMEDIATE_OR_CANCEL);
    }

    public String placeBittrexMarketOrder(MarketOrder marketOrder, TimeInForce type) throws IOException {
        BittrexNewOrder bittrexNewOrder = new BittrexNewOrder(BittrexUtils.toPairString(marketOrder.getCurrencyPair()), Order.OrderType.BID.equals((Object)marketOrder.getType()) ? "BUY" : "SELL", "MARKET", marketOrder.getRemainingAmount().toPlainString(), null, null, type.toString(), null, null);
        return this.bittrexAuthenticated.placeOrder(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, bittrexNewOrder).getId();
    }

    public BittrexOrder cancelBittrexLimitOrder(String orderId) throws IOException {
        return this.bittrexAuthenticated.cancelOrder(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, orderId);
    }

    public List<BittrexOrder> getBittrexOpenOrders(OpenOrdersParams params) throws IOException {
        return this.bittrexAuthenticated.getOpenOrders(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
    }

    public SequencedOpenOrders getBittrexSequencedOpenOrders(OpenOrdersParams params) throws IOException {
        BittrexOrders openOrders = this.bittrexAuthenticated.getOpenOrders(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
        return new SequencedOpenOrders(openOrders.getSequence(), BittrexAdapters.adaptOpenOrders(openOrders));
    }

    public List<BittrexOrder> getBittrexUserTradeHistory(CurrencyPair currencyPair, Date start, Date end) throws IOException {
        return (List)this.decorateApiCall(() -> this.bittrexAuthenticated.getClosedOrders(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, BittrexUtils.toPairString(currencyPair), 200, start, end)).withRetry(this.retry("getClosedOrders")).withRateLimiter(this.rateLimiter("closedOrdersRateLimiter")).call();
    }

    public List<BittrexOrder> getBittrexUserTradeHistory(CurrencyPair currencyPair) throws IOException {
        return this.getBittrexUserTradeHistory(currencyPair, null, null);
    }

    public List<BittrexOrder> getBittrexUserTradeHistory() throws IOException {
        return this.getBittrexUserTradeHistory(null);
    }

    public BittrexOrder getBittrexOrder(String orderId) throws IOException {
        return this.bittrexAuthenticated.getOrder(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, orderId);
    }

    public BatchResponse[] executeOrdersBatch(BatchOrder[] batchOrders) throws IOException {
        return this.bittrexAuthenticated.executeOrdersBatch(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, batchOrders);
    }

    public static class SequencedOpenOrders {
        private final String sequence;
        private final List<LimitOrder> openOrders;

        public SequencedOpenOrders(String sequence, List<LimitOrder> openOrders) {
            this.sequence = sequence;
            this.openOrders = openOrders;
        }

        public String getSequence() {
            return this.sequence;
        }

        public List<LimitOrder> getOpenOrders() {
            return this.openOrders;
        }
    }
}

