/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexDepth;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;

@Path(value="v3")
@Produces(value={"application/json"})
public interface Bittrex {
    @GET
    @Path(value="markets/{marketSymbol}/orderbook")
    public BittrexDepth getOrderBook(@PathParam(value="marketSymbol") String var1, @QueryParam(value="depth") int var2) throws IOException, BittrexException;

    @GET
    @Path(value="markets")
    public List<BittrexSymbol> getMarkets() throws IOException, BittrexException;

    @GET
    @Path(value="markets/{marketSymbol}/summary")
    public BittrexMarketSummary getMarketSummary(@PathParam(value="marketSymbol") String var1) throws IOException, BittrexException;

    @GET
    @Path(value="markets/summaries")
    public List<BittrexMarketSummary> getMarketSummaries() throws IOException, BittrexException;

    @GET
    @Path(value="markets/tickers")
    public List<BittrexTicker> getTickers() throws IOException, BittrexException;

    @GET
    @Path(value="markets/{marketSymbol}/trades")
    public List<BittrexTrade> getTrades(@PathParam(value="marketSymbol") String var1) throws IOException, BittrexException;

    @GET
    @Path(value="markets/{marketSymbol}/ticker")
    public BittrexTicker getTicker(@PathParam(value="marketSymbol") String var1) throws IOException, BittrexException;
}

