/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import org.knowm.xchange.client.ResilienceRegistries;

public final class BittrexResilience {
    public static final String PUBLIC_ENDPOINTS_RATE_LIMITER = "publicEndpointsRateLimiter";
    public static final String GET_ORDER_BOOKS_RATE_LIMITER = "orderBooksRateLimiter";
    public static final String GET_CLOSED_ORDERS_RATE_LIMITER = "closedOrdersRateLimiter";

    private BittrexResilience() {
    }

    public static ResilienceRegistries createRegistries() {
        ResilienceRegistries registries = new ResilienceRegistries();
        registries.rateLimiters().rateLimiter(GET_ORDER_BOOKS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(600).build());
        registries.rateLimiters().rateLimiter(GET_CLOSED_ORDERS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(20).build());
        registries.rateLimiters().rateLimiter(PUBLIC_ENDPOINTS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(60).build());
        return registries;
    }
}

