/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexErrorAdapter;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.service.BittrexTradeServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BittrexTradeService
extends BittrexTradeServiceRaw
implements TradeService {
    public BittrexTradeService(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        try {
            return this.placeBittrexLimitOrder(limitOrder);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            return new OpenOrders(BittrexAdapters.adaptOpenOrders(this.getBittrexOpenOrders(params)));
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(String orderId) throws IOException {
        try {
            return "CLOSED".equalsIgnoreCase(this.cancelBittrexLimitOrder(orderId).getStatus());
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        try {
            List<BittrexOrder> tradeHistory = params instanceof TradeHistoryParamCurrencyPair ? this.getBittrexUserTradeHistory(((TradeHistoryParamCurrencyPair)params).getCurrencyPair()) : this.getBittrexUserTradeHistory();
            return new UserTrades(BittrexAdapters.adaptUserTrades(tradeHistory), Trades.TradeSortType.SortByTimestamp);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new DefaultTradeHistoryParamCurrencyPair();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        try {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (String orderId : orderIds) {
                BittrexOrder order = this.getBittrexOrder(orderId);
                if (order == null) continue;
                LimitOrder limitOrder = BittrexAdapters.adaptOrder(order);
                orders.add((Order)limitOrder);
            }
            return orders;
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }
}

