/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.coinbase.dto.CoinbaseException;
import org.knowm.xchange.coinbase.dto.account.CoinbaseToken;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseCurrency;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbasePrice;

@Path(value="api/v1")
@Produces(value={"application/json"})
public interface Coinbase {
    @GET
    @Path(value="currencies")
    public List<CoinbaseCurrency> getCurrencies() throws IOException, CoinbaseException;

    @GET
    @Path(value="currencies/exchange_rates")
    public Map<String, BigDecimal> getCurrencyExchangeRates() throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/buy")
    public CoinbasePrice getBuyPrice(@QueryParam(value="qty") BigDecimal var1, @QueryParam(value="currency") String var2) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/sell")
    public CoinbasePrice getSellPrice(@QueryParam(value="qty") BigDecimal var1, @QueryParam(value="currency") String var2) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/spot_rate")
    public CoinbaseMoney getSpotRate(@QueryParam(value="currency") String var1) throws IOException, CoinbaseException;

    @GET
    @Produces(value={"text/plain"})
    @Path(value="prices/historical")
    public String getHistoricalSpotRates(@QueryParam(value="page") Integer var1) throws IOException, CoinbaseException;

    @POST
    @Consumes(value={"application/json"})
    @Path(value="users")
    public CoinbaseUser createUser(CoinbaseUser var1) throws IOException, CoinbaseException;

    @POST
    @Path(value="tokens")
    public CoinbaseToken createToken() throws IOException, CoinbaseException;
}

