/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseHistoricalSpotPrice;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbasePrice;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseSpotPriceHistory;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfer;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransferType;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfers;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;

public final class CoinbaseAdapters {
    private static final int TWENTY_FOUR_HOURS_IN_MILLIS = 86400000;

    private CoinbaseAdapters() {
    }

    public static AccountInfo adaptAccountInfo(CoinbaseUser user) {
        String username = user.getEmail();
        CoinbaseMoney money = user.getBalance();
        Balance balance = new Balance(Currency.getInstance((String)money.getCurrency()), money.getAmount());
        AccountInfo accountInfoTemporaryName = new AccountInfo(username, new Wallet[]{Wallet.Builder.from(Arrays.asList(balance)).build()});
        return accountInfoTemporaryName;
    }

    public static UserTrades adaptTrades(CoinbaseTransfers transfers) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (CoinbaseTransfer transfer : transfers.getTransfers()) {
            trades.add(CoinbaseAdapters.adaptTrade(transfer));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrade adaptTrade(CoinbaseTransfer transfer) {
        Order.OrderType orderType = CoinbaseAdapters.adaptOrderType(transfer.getType());
        CoinbaseMoney btcAmount = transfer.getBtcAmount();
        BigDecimal originalAmount = btcAmount.getAmount();
        String tradableIdentifier = btcAmount.getCurrency();
        CoinbaseMoney subTotal = transfer.getSubtotal();
        String transactionCurrency = subTotal.getCurrency();
        BigDecimal price = subTotal.getAmount().divide(originalAmount, RoundingMode.HALF_EVEN);
        Date timestamp = transfer.getCreatedAt();
        String id = transfer.getTransactionId();
        String transferId = transfer.getId();
        BigDecimal feeAmount = transfer.getCoinbaseFee().getAmount();
        String feeCurrency = transfer.getCoinbaseFee().getCurrency();
        return new UserTrade.Builder().type(orderType).originalAmount(originalAmount).currencyPair(new CurrencyPair(tradableIdentifier, transactionCurrency)).price(price).timestamp(timestamp).id(id).orderId(transferId).feeAmount(feeAmount).feeCurrency(Currency.getInstance((String)feeCurrency)).build();
    }

    public static Order.OrderType adaptOrderType(CoinbaseTransferType transferType) {
        switch (transferType) {
            case BUY: {
                return Order.OrderType.BID;
            }
            case SELL: {
                return Order.OrderType.ASK;
            }
        }
        return null;
    }

    public static Ticker adaptTicker(CurrencyPair currencyPair, CoinbasePrice buyPrice, CoinbasePrice sellPrice, CoinbaseMoney spotRate, CoinbaseSpotPriceHistory coinbaseSpotPriceHistory) {
        Ticker.Builder tickerBuilder = new Ticker.Builder().currencyPair(currencyPair).ask(buyPrice.getSubTotal().getAmount()).bid(sellPrice.getSubTotal().getAmount()).last(spotRate.getAmount());
        if (coinbaseSpotPriceHistory != null) {
            BigDecimal observedHigh = spotRate.getAmount();
            BigDecimal observedLow = spotRate.getAmount();
            Date twentyFourHoursAgo = null;
            for (CoinbaseHistoricalSpotPrice historicalSpotPrice : coinbaseSpotPriceHistory.getSpotPriceHistory()) {
                if (twentyFourHoursAgo == null) {
                    twentyFourHoursAgo = new Date(historicalSpotPrice.getTimestamp().getTime() - 86400000L);
                } else if (historicalSpotPrice.getTimestamp().before(twentyFourHoursAgo)) break;
                BigDecimal spotPriceAmount = historicalSpotPrice.getSpotRate();
                if (spotPriceAmount.compareTo(observedLow) < 0) {
                    observedLow = spotPriceAmount;
                    continue;
                }
                if (spotPriceAmount.compareTo(observedHigh) <= 0) continue;
                observedHigh = spotPriceAmount;
            }
            tickerBuilder.high(observedHigh).low(observedLow);
        }
        return tickerBuilder.build();
    }
}

