/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAccountChangeCategory;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.utils.jackson.ISO8601DateDeserializer;

public class CoinbaseAccountChange {
    private final String id;
    private final Date createdAt;
    private final String transactionId;
    private final boolean confirmed;
    private final CoinbaseCache cache;
    private final CoinbaseMoney amount;

    private CoinbaseAccountChange(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") @JsonDeserialize(using=ISO8601DateDeserializer.class) Date createdAt, @JsonProperty(value="transaction_id") String transactionId, @JsonProperty(value="confirmed") boolean confirmed, @JsonProperty(value="cache") CoinbaseCache cache, @JsonProperty(value="amount") CoinbaseMoney amount) {
        this.id = id;
        this.createdAt = createdAt;
        this.transactionId = transactionId;
        this.confirmed = confirmed;
        this.cache = cache;
        this.amount = amount;
    }

    public String getId() {
        return this.id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public CoinbaseCache getCache() {
        return this.cache;
    }

    public CoinbaseMoney getAmount() {
        return this.amount;
    }

    public String toString() {
        return "AccountChange [id=" + this.id + ", createdAt=" + this.createdAt + ", transactionId=" + this.transactionId + ", confirmed=" + this.confirmed + ", cache=" + this.cache + ", amount=" + this.amount + "]";
    }

    public static class CoinbaseCache {
        private final boolean notesPresent;
        private final CoinbaseAccountChangeCategory category;
        private final CoinbaseUser otherUser;

        private CoinbaseCache(@JsonProperty(value="notes_present") boolean notesPresent, @JsonProperty(value="category") CoinbaseAccountChangeCategory category, @JsonProperty(value="other_user") CoinbaseUser.CoinbaseUserInfo otherUser) {
            this.notesPresent = notesPresent;
            this.category = category;
            this.otherUser = new CoinbaseUser(otherUser);
        }

        public boolean isNotesPresent() {
            return this.notesPresent;
        }

        public CoinbaseAccountChangeCategory getCategory() {
            return this.category;
        }

        public CoinbaseUser getOtherUser() {
            return this.otherUser;
        }

        public String toString() {
            return "CoinbaseCache [notesPresent=" + this.notesPresent + ", category=" + (Object)((Object)this.category) + ", otherUser=" + this.otherUser + "]";
        }
    }
}

