/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.account.CoinbaseBuySellLevel;
import org.knowm.xchange.coinbase.dto.auth.CoinbaseOAuth;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseMerchant;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseMoneyDeserializer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CoinbaseUser
extends CoinbaseBaseResponse {
    @JsonProperty(value="user")
    private final CoinbaseUserInfo user;
    private final CoinbaseOAuth oAuth;
    @JsonProperty(value="client_id")
    private String oAuthClientId;

    private CoinbaseUser(@JsonProperty(value="user") CoinbaseUserInfo user, @JsonProperty(value="oauth") CoinbaseOAuth oAuth, @JsonProperty(value="success") boolean success, @JsonProperty(value="errors") List<String> errors) {
        super(success, errors);
        this.user = user;
        this.oAuth = oAuth;
    }

    public CoinbaseUser(CoinbaseUserInfo user) {
        super(true);
        this.user = user;
        this.oAuth = null;
    }

    public static CoinbaseUser createNewCoinbaseUser(String email, String password) {
        return new CoinbaseUser(new CoinbaseUserInfo(email, password, null));
    }

    public static CoinbaseUser createCoinbaseNewUserWithReferrerId(String email, String password, String referrerId) {
        return new CoinbaseUser(new CoinbaseUserInfo(email, password, referrerId));
    }

    @JsonIgnore
    public String getId() {
        return this.user.getId();
    }

    @JsonIgnore
    public String getEmail() {
        return this.user.getEmail();
    }

    public CoinbaseUser updateEmail(String email) {
        this.user.setEmail(email);
        return this;
    }

    @JsonIgnore
    public String getName() {
        return this.user.getName();
    }

    public CoinbaseUser updateName(String name) {
        this.user.setName(name);
        return this;
    }

    @JsonIgnore
    public String getPassword() {
        return this.user.getPassword();
    }

    @JsonIgnore
    public String getReceiveAddress() {
        return this.user.getReceiveAddress();
    }

    @JsonIgnore
    public String getReferrerId() {
        return this.user.getReferrerId();
    }

    @JsonIgnore
    public String getTimeZone() {
        return this.user.getTimeZone();
    }

    public CoinbaseUser updateTimeZone(String timeZone) {
        this.user.setTimeZone(timeZone);
        return this;
    }

    @JsonIgnore
    public CoinbaseMoney getBalance() {
        return this.user.getBalance();
    }

    @JsonIgnore
    public String getNativeCurrency() {
        return this.user.getNativeCurrency();
    }

    public CoinbaseUser updateNativeCurrency(String nativeCurrency) {
        this.user.setNativeCurrency(nativeCurrency);
        return this;
    }

    @JsonIgnore
    public CoinbaseBuySellLevel getBuyLevel() {
        return this.user.getBuyLevel();
    }

    @JsonIgnore
    public CoinbaseBuySellLevel getSellLevel() {
        return this.user.getSellLevel();
    }

    @JsonIgnore
    public CoinbaseMoney getBuyLimit() {
        return this.user.getBuyLimit();
    }

    @JsonIgnore
    public CoinbaseMoney getSellLimit() {
        return this.user.getSellLimit();
    }

    @JsonIgnore
    public String getPin() {
        return this.user.getPin();
    }

    public CoinbaseUser updatePin(String pin) {
        this.user.setPin(pin);
        return this;
    }

    @JsonIgnore
    public CoinbaseMerchant getMerchant() {
        return this.user.getMerchant();
    }

    @JsonIgnore
    public CoinbaseOAuth getOAuth() {
        return this.oAuth;
    }

    public String getoAuthClientId() {
        return this.oAuthClientId;
    }

    public CoinbaseUser withoAuthClientId(String oAuthClientId) {
        this.oAuthClientId = oAuthClientId;
        return this;
    }

    @Override
    public String toString() {
        return "CoinbaseUser [user=" + this.user + ", oAuth=" + this.oAuth + ", oAuthClientId=" + this.oAuthClientId + "]";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CoinbaseUserInfo {
        private final String id;
        @JsonProperty(value="password")
        private final String password;
        private final String receiveAddress;
        @JsonProperty(value="referrer_id")
        private final String referrerId;
        private final CoinbaseMoney balance;
        private final CoinbaseBuySellLevel buyLevel;
        private final CoinbaseBuySellLevel sellLevel;
        private final CoinbaseMoney buyLimit;
        private final CoinbaseMoney sellLimit;
        private final CoinbaseMerchant merchant;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="time_zone")
        private String timeZone;
        @JsonProperty(value="native_currency")
        private String nativeCurrency;
        @JsonProperty(value="pin")
        private String pin;

        private CoinbaseUserInfo(@JsonProperty(value="id") String id, @JsonProperty(value="email") String email, @JsonProperty(value="name") String name, @JsonProperty(value="password") String password, @JsonProperty(value="receive_address") String receiveAddress, @JsonProperty(value="referrer_id") String referrerId, @JsonProperty(value="time_zone") String timeZone, @JsonProperty(value="balance") @JsonDeserialize(using=CoinbaseMoneyDeserializer.class) CoinbaseMoney balance, @JsonProperty(value="native_currency") String nativeCurrency, @JsonProperty(value="buy_level") CoinbaseBuySellLevel buyLevel, @JsonProperty(value="sell_level") CoinbaseBuySellLevel sellLevel, @JsonProperty(value="buy_limit") @JsonDeserialize(using=CoinbaseMoneyDeserializer.class) CoinbaseMoney buyLimit, @JsonProperty(value="sell_limit") @JsonDeserialize(using=CoinbaseMoneyDeserializer.class) CoinbaseMoney sellLimit, @JsonProperty(value="pin") String pin, @JsonProperty(value="merchant") CoinbaseMerchant merchant) {
            this.id = id;
            this.email = email;
            this.name = name;
            this.password = password;
            this.receiveAddress = receiveAddress;
            this.referrerId = referrerId;
            this.timeZone = timeZone;
            this.balance = balance;
            this.nativeCurrency = nativeCurrency;
            this.buyLevel = buyLevel;
            this.sellLevel = sellLevel;
            this.buyLimit = buyLimit;
            this.sellLimit = sellLimit;
            this.pin = pin;
            this.merchant = merchant;
        }

        private CoinbaseUserInfo(String email, String password, String referrerId) {
            this.email = email;
            this.password = password;
            this.referrerId = referrerId;
            this.id = null;
            this.name = null;
            this.receiveAddress = null;
            this.timeZone = null;
            this.balance = null;
            this.nativeCurrency = null;
            this.buyLevel = null;
            this.sellLevel = null;
            this.buyLimit = null;
            this.sellLimit = null;
            this.pin = null;
            this.merchant = null;
        }

        @JsonIgnore
        public String getId() {
            return this.id;
        }

        public String getEmail() {
            return this.email;
        }

        private void setEmail(String email) {
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        @JsonIgnore
        public String getReceiveAddress() {
            return this.receiveAddress;
        }

        public String getReferrerId() {
            return this.referrerId;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        private void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @JsonIgnore
        public CoinbaseMoney getBalance() {
            return this.balance;
        }

        public String getNativeCurrency() {
            return this.nativeCurrency;
        }

        private void setNativeCurrency(String nativeCurrency) {
            this.nativeCurrency = nativeCurrency;
        }

        @JsonIgnore
        public CoinbaseBuySellLevel getBuyLevel() {
            return this.buyLevel;
        }

        @JsonIgnore
        public CoinbaseBuySellLevel getSellLevel() {
            return this.sellLevel;
        }

        @JsonIgnore
        public CoinbaseMoney getBuyLimit() {
            return this.buyLimit;
        }

        @JsonIgnore
        public CoinbaseMoney getSellLimit() {
            return this.sellLimit;
        }

        public String getPin() {
            return this.pin;
        }

        private void setPin(String pin) {
            this.pin = pin;
        }

        @JsonIgnore
        public CoinbaseMerchant getMerchant() {
            return this.merchant;
        }

        public String toString() {
            return "CoinbaseUserInfo [id=" + this.id + ", email=" + this.email + ", name=" + this.name + ", password=" + this.password + ", receiveAddress=" + this.receiveAddress + ", referrerId=" + this.referrerId + ", timeZone=" + this.timeZone + ", balance=" + this.balance + ", nativeCurrency=" + this.nativeCurrency + ", buyLevel=" + (Object)((Object)this.buyLevel) + ", sellLevel=" + (Object)((Object)this.sellLevel) + ", buyLimit=" + this.buyLimit + ", sellLimit=" + this.sellLimit + ", pin=" + this.pin + ", merchant=" + this.merchant + "]";
        }
    }
}

