/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.merchant;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButton;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseCentsDeserializer;
import org.knowm.xchange.coinbase.dto.serialization.EnumFromStringHelper;
import org.knowm.xchange.coinbase.dto.serialization.EnumLowercaseJsonSerializer;
import org.knowm.xchange.utils.jackson.ISO8601DateDeserializer;

public class CoinbaseOrder
extends CoinbaseBaseResponse {
    @JsonProperty(value="order")
    private CoinbaseOrderInfo order;

    private CoinbaseOrder(@JsonProperty(value="order") CoinbaseOrderInfo order, @JsonProperty(value="success") boolean success, @JsonProperty(value="errors") List<String> errors) {
        super(success, errors);
        this.order = order;
    }

    public String getId() {
        return this.order.getId();
    }

    public Date getCreatedAt() {
        return this.order.getCreatedAt();
    }

    public CoinbaseOrderStatus getStatus() {
        return this.order.getStatus();
    }

    public CoinbaseMoney getTotalBTC() {
        return this.order.getTotalBTC();
    }

    public CoinbaseMoney getTotalNative() {
        return this.order.getTotalNative();
    }

    public String getCustom() {
        return this.order.getCustom();
    }

    public String getReceiveAddress() {
        return this.order.getReceiveAddress();
    }

    public CoinbaseButton getButton() {
        return this.order.getButton();
    }

    public CoinbaseOrderTransaction getTransaction() {
        return this.order.getTransaction();
    }

    @Override
    public String toString() {
        return "CoinbaseOrder [order=" + this.order + "]";
    }

    public static class CoinbaseOrderTransaction {
        private final String id;
        private final String hash;
        private final int confirmations;

        private CoinbaseOrderTransaction(@JsonProperty(value="id") String id, @JsonProperty(value="hash") String hash, @JsonProperty(value="confirmations") int confirmations) {
            this.id = id;
            this.hash = hash;
            this.confirmations = confirmations;
        }

        public String getId() {
            return this.id;
        }

        public String getHash() {
            return this.hash;
        }

        public int getConfirmations() {
            return this.confirmations;
        }

        public String toString() {
            return "CoinbaseOrderTransaction [id=" + this.id + ", hash=" + this.hash + ", confirmations=" + this.confirmations + "]";
        }
    }

    private static class CoinbaseOrderInfo {
        private final String id;
        private final Date createdAt;
        private final CoinbaseOrderStatus status;
        private final CoinbaseMoney totalBTC;
        private final CoinbaseMoney totalNative;
        private final String custom;
        private final String receiveAddress;
        private final CoinbaseButton button;
        private final CoinbaseOrderTransaction transaction;

        private CoinbaseOrderInfo(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") @JsonDeserialize(using=ISO8601DateDeserializer.class) Date createdAt, @JsonProperty(value="status") CoinbaseOrderStatus status, @JsonProperty(value="total_btc") @JsonDeserialize(using=CoinbaseCentsDeserializer.class) CoinbaseMoney totalBTC, @JsonProperty(value="total_native") @JsonDeserialize(using=CoinbaseCentsDeserializer.class) CoinbaseMoney totalNative, @JsonProperty(value="custom") String custom, @JsonProperty(value="receive_address") String receiveAddress, @JsonProperty(value="button") CoinbaseButton.CoinbaseButtonInfo button, @JsonProperty(value="transaction") CoinbaseOrderTransaction transaction) {
            this.id = id;
            this.createdAt = createdAt;
            this.status = status;
            this.totalBTC = totalBTC;
            this.totalNative = totalNative;
            this.custom = custom;
            this.receiveAddress = receiveAddress;
            this.button = new CoinbaseButton(button);
            this.transaction = transaction;
        }

        public String getId() {
            return this.id;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public CoinbaseOrderStatus getStatus() {
            return this.status;
        }

        public CoinbaseMoney getTotalBTC() {
            return this.totalBTC;
        }

        public CoinbaseMoney getTotalNative() {
            return this.totalNative;
        }

        public String getCustom() {
            return this.custom;
        }

        public String getReceiveAddress() {
            return this.receiveAddress;
        }

        public CoinbaseButton getButton() {
            return this.button;
        }

        public CoinbaseOrderTransaction getTransaction() {
            return this.transaction;
        }

        public String toString() {
            return "CoinbaseOrderInfo [id=" + this.id + ", createdAt=" + this.createdAt + ", status=" + (Object)((Object)this.status) + ", totalBTC=" + this.totalBTC + ", totalNative=" + this.totalNative + ", custom=" + this.custom + ", receiveAddress=" + this.receiveAddress + ", button=" + this.button + ", transaction=" + this.transaction + "]";
        }
    }

    static class CoinbaseOrderStatusDeserializer
    extends JsonDeserializer<CoinbaseOrderStatus> {
        private static final EnumFromStringHelper<CoinbaseOrderStatus> FROM_STRING_HELPER = new EnumFromStringHelper<CoinbaseOrderStatus>(CoinbaseOrderStatus.class);

        CoinbaseOrderStatusDeserializer() {
        }

        public CoinbaseOrderStatus deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String jsonString = node.textValue();
            return FROM_STRING_HELPER.fromJsonString(jsonString);
        }
    }

    @JsonDeserialize(using=CoinbaseOrderStatusDeserializer.class)
    @JsonSerialize(using=EnumLowercaseJsonSerializer.class)
    public static enum CoinbaseOrderStatus {
        NEW,
        COMPLETED,
        CANCELED;

    }
}

