/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.merchant;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import org.knowm.xchange.coinbase.dto.common.CoinbaseRecurringPaymentStatus;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButton;
import org.knowm.xchange.utils.jackson.ISO8601DateDeserializer;

public class CoinbaseSubscription {
    private final CoinbaseSubscriptionInfo subscription;

    private CoinbaseSubscription(@JsonProperty(value="recurring_payment") CoinbaseSubscriptionInfo subscription) {
        this.subscription = subscription;
    }

    public String getId() {
        return this.subscription.getId();
    }

    public Date getCreatedAt() {
        return this.subscription.getCreatedAt();
    }

    public CoinbaseRecurringPaymentStatus getStatus() {
        return this.subscription.getStatus();
    }

    public String getCustom() {
        return this.subscription.getCustom();
    }

    public CoinbaseButton getButton() {
        return this.subscription.getButton();
    }

    public String toString() {
        return "CoinbaseSubscription [subscription=" + this.subscription + "]";
    }

    private static final class CoinbaseSubscriptionInfo {
        private final String id;
        private final Date createdAt;
        private final CoinbaseRecurringPaymentStatus status;
        private final String custom;
        private final CoinbaseButton button;

        private CoinbaseSubscriptionInfo(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") @JsonDeserialize(using=ISO8601DateDeserializer.class) Date createdAt, @JsonProperty(value="status") CoinbaseRecurringPaymentStatus status, @JsonProperty(value="custom") String custom, @JsonProperty(value="button") CoinbaseButton.CoinbaseButtonInfo button) {
            this.id = id;
            this.createdAt = createdAt;
            this.status = status;
            this.custom = custom;
            this.button = new CoinbaseButton(button);
        }

        public String getId() {
            return this.id;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public CoinbaseRecurringPaymentStatus getStatus() {
            return this.status;
        }

        public String getCustom() {
            return this.custom;
        }

        public CoinbaseButton getButton() {
            return this.button;
        }

        public String toString() {
            return "CoinbaseSubscriptionInfo [id=" + this.id + ", createdAt=" + this.createdAt + ", status=" + (Object)((Object)this.status) + ", custom=" + this.custom + ", button=" + this.button + "]";
        }
    }
}

