/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.CoinbaseAuthenticated;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.account.CoinbaseToken;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseCurrency;
import org.knowm.xchange.coinbase.service.CoinbaseDigest;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class CoinbaseBaseService
extends BaseExchangeService
implements BaseService {
    protected final CoinbaseAuthenticated coinbase;
    protected final ParamsDigest signatureCreator;

    protected CoinbaseBaseService(Exchange exchange) {
        super(exchange);
        this.coinbase = (CoinbaseAuthenticated)RestProxyFactory.createProxy(CoinbaseAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.signatureCreator = CoinbaseDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public List<CoinbaseCurrency> getCoinbaseCurrencies() throws IOException {
        return this.coinbase.getCurrencies();
    }

    public CoinbaseUser createCoinbaseUser(CoinbaseUser user) throws IOException {
        CoinbaseUser createdUser = this.coinbase.createUser(user);
        return this.handleResponse(createdUser);
    }

    public CoinbaseUser createCoinbaseUser(CoinbaseUser user, String oAuthClientId) throws IOException {
        CoinbaseUser createdUser = this.coinbase.createUser(user.withoAuthClientId(oAuthClientId));
        return this.handleResponse(createdUser);
    }

    public CoinbaseToken createCoinbaseToken() throws IOException {
        CoinbaseToken token = this.coinbase.createToken();
        return this.handleResponse(token);
    }

    protected <R extends CoinbaseBaseResponse> R handleResponse(R response) {
        List<String> errors = response.getErrors();
        if (errors != null && !errors.isEmpty()) {
            throw new ExchangeException(errors.toString());
        }
        return response;
    }
}

