/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.CoinbaseAdapters;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbasePrice;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseSpotPriceHistory;
import org.knowm.xchange.coinbase.service.CoinbaseMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CoinbaseMarketDataService
extends CoinbaseMarketDataServiceRaw
implements MarketDataService {
    public CoinbaseMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        String currency = currencyPair.counter.getCurrencyCode();
        CoinbasePrice buyPrice = super.getCoinbaseBuyPrice(BigDecimal.ONE, currency);
        CoinbasePrice sellPrice = super.getCoinbaseSellPrice(BigDecimal.ONE, currency);
        CoinbaseMoney spotRate = super.getCoinbaseSpotRate(currency);
        CoinbaseSpotPriceHistory coinbaseSpotPriceHistory = args != null && args.length > 0 && args[0] != null && args[0] instanceof Boolean && (Boolean)args[0] != false ? super.getCoinbaseHistoricalSpotRates() : null;
        return CoinbaseAdapters.adaptTicker(currencyPair, buyPrice, sellPrice, spotRate, coinbaseSpotPriceHistory);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) {
        throw new NotAvailableFromExchangeException();
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) {
        throw new NotAvailableFromExchangeException();
    }
}

