/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.coinbase.v2.dto.CoinbaseException;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbaseCurrencyData;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbaseExchangeRateData;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbasePriceData;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbaseTimeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
public interface Coinbase {
    public static final Logger LOG = LoggerFactory.getLogger((String)Coinbase.class.getPackage().getName());
    public static final String CB_VERSION = "CB-VERSION";
    public static final String CB_VERSION_VALUE = "2018-04-08";

    @GET
    @Path(value="currencies")
    public CoinbaseCurrencyData getCurrencies(@HeaderParam(value="CB-VERSION") String var1) throws IOException, CoinbaseException;

    @GET
    @Path(value="exchange-rates")
    public CoinbaseExchangeRateData getCurrencyExchangeRates(@HeaderParam(value="CB-VERSION") String var1) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/{pair}/buy")
    public CoinbasePriceData getBuyPrice(@HeaderParam(value="CB-VERSION") String var1, @PathParam(value="pair") String var2) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/{pair}/sell")
    public CoinbasePriceData getSellPrice(@HeaderParam(value="CB-VERSION") String var1, @PathParam(value="pair") String var2) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/{pair}/spot")
    public CoinbasePriceData getSpotRate(@HeaderParam(value="CB-VERSION") String var1, @PathParam(value="pair") String var2) throws IOException, CoinbaseException;

    @GET
    @Path(value="prices/{pair}/spot")
    public CoinbasePriceData getHistoricalSpotRate(@HeaderParam(value="CB-VERSION") String var1, @PathParam(value="pair") String var2, @QueryParam(value="date") String var3) throws IOException, CoinbaseException;

    @GET
    @Path(value="time")
    public CoinbaseTimeData getTime(@HeaderParam(value="CB-VERSION") String var1) throws IOException, CoinbaseException;
}

