/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2;

import javax.ws.rs.HeaderParam;
import org.knowm.xchange.coinbase.v2.Coinbase;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class CoinbaseV2Digest
extends BaseParamsDigest {
    private CoinbaseV2Digest(String secretKey) {
        super(secretKey, "HmacSHA256");
    }

    public static CoinbaseV2Digest createInstance(String secretKey) {
        return secretKey == null ? null : new CoinbaseV2Digest(secretKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        String timestamp = restInvocation.getParamValue(HeaderParam.class, "CB-ACCESS-TIMESTAMP").toString();
        String methodPath = "/v2" + restInvocation.getPath();
        String message = timestamp + restInvocation.getHttpMethod() + methodPath;
        Object body = null;
        String sign = DigestUtils.bytesToHex((byte[])this.getMac().doFinal(message.getBytes()));
        return sign;
    }

    protected void showCurl(String method, String apiKey, String timestamp, String signature, String path, String json) {
        String headers = String.format("-H 'CB-VERSION: 2017-11-26' -H 'CB-ACCESS-KEY: %s' -H 'CB-ACCESS-SIGN: %s' -H 'CB-ACCESS-TIMESTAMP: %s'", apiKey, signature, timestamp);
        if (method.equalsIgnoreCase("get")) {
            Coinbase.LOG.debug(String.format("curl %s https://api.coinbase.com%s", headers, path));
        } else if (method.equalsIgnoreCase("POST")) {
            String payload = "-d '" + json + "'";
            Coinbase.LOG.debug(String.format("curl -X %s -H 'Content-Type: %s' %s %s https://api.coinbase.com%s", method, "application/json", headers, payload, path));
        }
    }
}

