/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.utils.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CoinbaseAmount {
    private final String currency;
    private final BigDecimal amount;
    private final String toString;

    @JsonCreator
    public CoinbaseAmount(@JsonProperty(value="currency") String currency, @JsonProperty(value="amount") BigDecimal amount) {
        Assert.notNull((Object)currency, (String)"Null currency");
        Assert.notNull((Object)amount, (String)"Null amount");
        this.currency = currency;
        this.amount = amount;
        this.toString = String.format("%.8f %s", amount, currency);
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoinbaseAmount other = (CoinbaseAmount)obj;
        return this.amount.compareTo(other.amount) == 0 && this.currency.equals(other.currency);
    }

    public String toString() {
        return this.toString;
    }
}

