/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.dto.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.knowm.xchange.coinbase.v2.dto.CoinbaseAmount;
import org.knowm.xchange.coinbase.v2.dto.CoinbasePrice;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class CoinbaseWalletResponseData<T extends CoinbaseWalletResponse> {
    private final T data;

    CoinbaseWalletResponseData(@JsonProperty(value="data") T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "" + this.data;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class CoinbaseWalletResponse {
        private final String id;
        private final String status;
        private final String transaction;
        private final boolean committed;
        private CoinbaseAmount amount;
        private CoinbasePrice fee;
        private CoinbasePrice total;
        private CoinbasePrice subtotal;

        @JsonCreator
        CoinbaseWalletResponse(@JsonProperty(value="id") String id, @JsonProperty(value="status") String status, @JsonProperty(value="transaction") String transaction, @JsonProperty(value="commited") boolean committed) {
            this.id = id;
            this.status = status;
            this.transaction = transaction;
            this.committed = committed;
        }

        public String getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTransaction() {
            return this.transaction;
        }

        public boolean isCommitted() {
            return this.committed;
        }

        public CoinbasePrice getFee() {
            return this.fee;
        }

        void setFee(CoinbasePrice fee) {
            this.fee = fee;
        }

        public CoinbaseAmount getAmount() {
            return this.amount;
        }

        void setAmount(CoinbaseAmount amount) {
            this.amount = amount;
        }

        public CoinbasePrice getTotal() {
            return this.total;
        }

        void setTotal(CoinbasePrice total) {
            this.total = total;
        }

        public CoinbasePrice getSubtotal() {
            return this.subtotal;
        }

        void setSubtotal(CoinbasePrice subtotal) {
            this.subtotal = subtotal;
        }

        public String toString() {
            String curr = this.amount.getCurrency();
            int scale = "EUR".equals(curr) || "USD".equals(curr) ? 2 : 8;
            String astr = String.format("amount=%." + scale + "f %s", this.amount.getAmount(), curr);
            String prices = "fee=" + this.fee + ",subtotal=" + this.subtotal + ",total=" + this.total;
            return this.getClass().getSimpleName() + "[id=" + this.id + ",status=" + this.status + ",committed=" + this.committed + "," + astr + "," + prices + "]";
        }
    }
}

