/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.v2.dto.CoinbasePrice;
import org.knowm.xchange.coinbase.v2.service.CoinbaseBaseService;
import org.knowm.xchange.currency.Currency;

class CoinbaseMarketDataServiceRaw
extends CoinbaseBaseService {
    public CoinbaseMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, BigDecimal> getCoinbaseExchangeRates() throws IOException {
        return this.coinbase.getCurrencyExchangeRates("2018-04-08").getData().getRates();
    }

    public CoinbasePrice getCoinbaseBuyPrice(Currency base, Currency counter) throws IOException {
        return this.coinbase.getBuyPrice("2018-04-08", base + "-" + counter).getData();
    }

    public CoinbasePrice getCoinbaseSellPrice(Currency base, Currency counter) throws IOException {
        return this.coinbase.getSellPrice("2018-04-08", base + "-" + counter).getData();
    }

    public CoinbasePrice getCoinbaseSpotRate(Currency base, Currency counter) throws IOException {
        return this.coinbase.getSpotRate("2018-04-08", base + "-" + counter).getData();
    }

    public CoinbasePrice getCoinbaseHistoricalSpotRate(Currency base, Currency counter, Date date) throws IOException {
        String datespec = new SimpleDateFormat("yyyy-MM-dd").format(date);
        return this.coinbase.getHistoricalSpotRate("2018-04-08", base + "-" + counter, datespec).getData();
    }
}

