/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseBuyData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseSellData;
import org.knowm.xchange.coinbase.v2.service.CoinbaseBaseService;
import org.knowm.xchange.currency.Currency;

class CoinbaseTradeServiceRaw
extends CoinbaseBaseService {
    protected CoinbaseTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinbaseBuyData.CoinbaseBuy buy(String accountId, BigDecimal total, Currency currency, boolean commit) throws IOException {
        String path = "/v2/accounts/" + accountId + "/buys";
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        BuyPayload payload = new BuyPayload(total, currency.getCurrencyCode(), commit, false);
        String body = new ObjectMapper().writeValueAsString((Object)payload);
        String signature = this.getSignature(timestamp, CoinbaseBaseService.HttpMethod.POST, path, body);
        this.showCurl(CoinbaseBaseService.HttpMethod.POST, apiKey, timestamp, signature, path, body);
        return (CoinbaseBuyData.CoinbaseBuy)this.coinbase.buy("application/json", "2018-04-08", apiKey, signature, timestamp, accountId, payload).getData();
    }

    public CoinbaseSellData.CoinbaseSell sell(String accountId, BigDecimal total, Currency currency, boolean commit) throws IOException {
        return this.sellInternal(accountId, new SellPayload(total, currency.getCurrencyCode(), commit, false));
    }

    public CoinbaseSellData.CoinbaseSell quote(String accountId, BigDecimal total, Currency currency) throws IOException {
        return this.sellInternal(accountId, new SellPayload(total, currency.getCurrencyCode(), false, true));
    }

    private CoinbaseSellData.CoinbaseSell sellInternal(String accountId, SellPayload payload) throws IOException {
        String path = "/v2/accounts/" + accountId + "/sells";
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        String body = new ObjectMapper().writeValueAsString((Object)payload);
        String signature = this.getSignature(timestamp, CoinbaseBaseService.HttpMethod.POST, path, body);
        this.showCurl(CoinbaseBaseService.HttpMethod.POST, apiKey, timestamp, signature, path, body);
        return (CoinbaseSellData.CoinbaseSell)this.coinbase.sell("application/json", "2018-04-08", apiKey, signature, timestamp, accountId, payload).getData();
    }

    abstract class AbstractPayload {
        @JsonProperty
        String currency;
        @JsonProperty
        boolean commit;
        @JsonProperty
        boolean quote;

        AbstractPayload(String currency, boolean commit, boolean quote) {
            this.currency = currency;
            this.commit = commit;
            this.quote = quote;
        }
    }

    class SellPayload
    extends AbstractPayload {
        @JsonProperty
        String amount;

        SellPayload(BigDecimal amount, String currency, boolean commit, boolean quote) {
            super(currency, commit, quote);
            this.amount = amount.toString();
        }
    }

    class BuyPayload
    extends AbstractPayload {
        @JsonProperty
        String total;

        BuyPayload(BigDecimal total, String currency, boolean commit, boolean quote) {
            super(currency, commit, quote);
            this.total = total.toString();
        }
    }
}

