/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.account.CoinbaseTransactionInfo;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.serialization.EnumFromStringHelper;
import org.knowm.xchange.utils.jackson.ISO8601DateDeserializer;

public class CoinbaseTransaction
extends CoinbaseBaseResponse
implements CoinbaseTransactionInfo {
    @JsonProperty(value="transaction")
    private final CoinbaseTransactionInfo transaction;

    private CoinbaseTransaction(@JsonProperty(value="transaction") CoinbaseTransactionInfoResult transaction, @JsonProperty(value="success") boolean success, @JsonProperty(value="errors") List<String> errors) {
        super(success, errors);
        this.transaction = transaction;
    }

    public CoinbaseTransaction(CoinbaseTransactionInfo transaction) {
        super(true, null);
        this.transaction = transaction;
    }

    public static CoinbaseRequestMoneyRequest createMoneyRequest(String from, CoinbaseMoney amount) {
        return CoinbaseTransaction.createMoneyRequest(from, amount.getCurrency(), amount.getAmount());
    }

    public static CoinbaseRequestMoneyRequest createMoneyRequest(String from, String currency, BigDecimal amount) {
        return CoinbaseTransaction.createMoneyRequest(from, currency, amount.toPlainString());
    }

    public static CoinbaseRequestMoneyRequest createMoneyRequest(String from, String currency, String amountString) {
        return new CoinbaseRequestMoneyRequest(from, currency, amountString);
    }

    public static CoinbaseSendMoneyRequest createSendMoneyRequest(String from, CoinbaseMoney amount) {
        return CoinbaseTransaction.createSendMoneyRequest(from, amount.getCurrency(), amount.getAmount());
    }

    public static CoinbaseSendMoneyRequest createSendMoneyRequest(String from, String currency, BigDecimal amount) {
        return CoinbaseTransaction.createSendMoneyRequest(from, currency, amount.toPlainString());
    }

    public static CoinbaseSendMoneyRequest createSendMoneyRequest(String from, String currency, String amountString) {
        return new CoinbaseSendMoneyRequest(from, currency, amountString);
    }

    @Override
    public String getId() {
        return this.transaction.getId();
    }

    @Override
    public Date getCreatedAt() {
        return this.transaction.getCreatedAt();
    }

    @Override
    public CoinbaseMoney getAmount() {
        return this.transaction.getAmount();
    }

    @Override
    public boolean isRequest() {
        return this.transaction.isRequest();
    }

    @Override
    public CoinbaseTransactionStatus getStatus() {
        return this.transaction.getStatus();
    }

    @Override
    public CoinbaseUser getSender() {
        return this.transaction.getSender();
    }

    @Override
    public CoinbaseUser getRecipient() {
        return this.transaction.getRecipient();
    }

    @Override
    public String getRecipientAddress() {
        return this.transaction.getRecipientAddress();
    }

    @Override
    public String getNotes() {
        return this.transaction.getNotes();
    }

    @Override
    public String getTransactionHash() {
        return this.transaction.getTransactionHash();
    }

    @Override
    public String getIdempotencyKey() {
        return this.transaction.getIdempotencyKey();
    }

    @Override
    public String toString() {
        return "CoinbaseTransaction [transaction=" + this.transaction + "]";
    }

    public static class CoinbaseRequestMoneyRequest
    extends CoinbaseTransactionRequest {
        @JsonProperty(value="from")
        private final String from;

        private CoinbaseRequestMoneyRequest(String from, String currency, String amountString) {
            super(currency, amountString);
            this.from = from;
        }

        public String getFrom() {
            return this.from;
        }

        @Override
        public CoinbaseRequestMoneyRequest withNotes(String notes) {
            this.notes = notes;
            return this;
        }
    }

    public static class CoinbaseSendMoneyRequest
    extends CoinbaseTransactionRequest {
        @JsonProperty(value="to")
        private final String to;
        @JsonProperty(value="user_fee")
        private String userFee;
        @JsonProperty(value="referrer_id")
        private String referrerId;
        @JsonProperty(value="idem")
        private String idempotencyKey;
        @JsonProperty(value="instant_buy")
        private boolean instantBuy;

        private CoinbaseSendMoneyRequest(String to, String currency, String amountString) {
            super(currency, amountString);
            this.to = to;
        }

        public String getTo() {
            return this.to;
        }

        @Override
        public CoinbaseSendMoneyRequest withNotes(String notes) {
            this.notes = notes;
            return this;
        }

        public String getUserFee() {
            return this.userFee;
        }

        public CoinbaseSendMoneyRequest withUserFee(String userFee) {
            this.userFee = userFee;
            return this;
        }

        public String getReferrerId() {
            return this.referrerId;
        }

        public CoinbaseSendMoneyRequest withReferrerId(String referrerId) {
            this.referrerId = referrerId;
            return this;
        }

        @Override
        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public CoinbaseSendMoneyRequest withIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public boolean isInstantBuy() {
            return this.instantBuy;
        }

        public CoinbaseSendMoneyRequest withInstantBuy(boolean instantBuy) {
            this.instantBuy = instantBuy;
            return this;
        }

        public String toString() {
            return "CoinbaseSendMoneyRequest [to=" + this.to + ", userFee=" + this.userFee + ", referrerId=" + this.referrerId + ", idempotencyKey=" + this.idempotencyKey + ", instantBuy=" + this.instantBuy + "]";
        }
    }

    @JsonDeserialize(using=CoinbaseTransactionStatusDeserializer.class)
    public static enum CoinbaseTransactionStatus {
        PENDING,
        COMPLETE;

    }

    private static class CoinbaseTransactionInfoResult
    implements CoinbaseTransactionInfo {
        private final String id;
        private final Date createdAt;
        private final CoinbaseMoney amount;
        private final boolean request;
        private final CoinbaseTransactionStatus status;
        private final CoinbaseUser sender;
        private final CoinbaseUser recipient;
        private final String recipientAddress;
        private final String notes;
        private final String transactionHash;
        private final String idempotencyKey;

        private CoinbaseTransactionInfoResult(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") @JsonDeserialize(using=ISO8601DateDeserializer.class) Date createdAt, @JsonProperty(value="amount") CoinbaseMoney amount, @JsonProperty(value="request") boolean request, @JsonProperty(value="status") CoinbaseTransactionStatus status, @JsonProperty(value="sender") CoinbaseUser.CoinbaseUserInfo sender, @JsonProperty(value="recipient") CoinbaseUser.CoinbaseUserInfo recipient, @JsonProperty(value="recipient_address") String recipientAddress, @JsonProperty(value="notes") String notes, @JsonProperty(value="hsh") String transactionHash, @JsonProperty(value="idem") String idempotencyKey) {
            this.id = id;
            this.createdAt = createdAt;
            this.amount = amount;
            this.request = request;
            this.status = status;
            this.sender = new CoinbaseUser(sender);
            this.recipient = new CoinbaseUser(recipient);
            this.recipientAddress = recipientAddress;
            this.notes = notes;
            this.transactionHash = transactionHash;
            this.idempotencyKey = idempotencyKey;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public CoinbaseMoney getAmount() {
            return this.amount;
        }

        @Override
        public boolean isRequest() {
            return this.request;
        }

        @Override
        public CoinbaseTransactionStatus getStatus() {
            return this.status;
        }

        @Override
        public CoinbaseUser getSender() {
            return this.sender;
        }

        @Override
        public CoinbaseUser getRecipient() {
            return this.recipient;
        }

        @Override
        public String getRecipientAddress() {
            return this.recipientAddress;
        }

        @Override
        public String getNotes() {
            return this.notes;
        }

        @Override
        public String getTransactionHash() {
            return this.transactionHash;
        }

        @Override
        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public String toString() {
            return "CoinbaseTransactionInfoResult [id=" + this.id + ", createdAt=" + this.createdAt + ", amount=" + this.amount + ", request=" + this.request + ", status=" + (Object)((Object)this.status) + ", sender=" + this.sender + ", recipient=" + this.recipient + ", recipientAddress=" + this.recipientAddress + ", notes=" + this.notes + ", transactionHash=" + this.transactionHash + ", idempotencyKey=" + this.idempotencyKey + "]";
        }
    }

    private static abstract class CoinbaseTransactionRequest
    implements CoinbaseTransactionInfo {
        @JsonProperty(value="amount_string")
        private final String amountString;
        @JsonProperty(value="amount_currency_iso")
        private final String currencyIso;
        @JsonProperty(value="notes")
        protected String notes;

        private CoinbaseTransactionRequest(String currency, String amountString) {
            this.amountString = amountString;
            this.currencyIso = currency;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public Date getCreatedAt() {
            return null;
        }

        @Override
        public CoinbaseMoney getAmount() {
            return new CoinbaseMoney(this.currencyIso, new BigDecimal(this.amountString));
        }

        @Override
        public boolean isRequest() {
            return true;
        }

        @Override
        public CoinbaseTransactionStatus getStatus() {
            return null;
        }

        @Override
        public CoinbaseUser getSender() {
            return null;
        }

        @Override
        public CoinbaseUser getRecipient() {
            return null;
        }

        @Override
        public String getRecipientAddress() {
            return null;
        }

        @Override
        public String getNotes() {
            return this.notes;
        }

        public abstract CoinbaseTransactionRequest withNotes(String var1);

        @Override
        public String getTransactionHash() {
            return null;
        }

        @Override
        public String getIdempotencyKey() {
            return null;
        }
    }

    static class CoinbaseTransactionStatusDeserializer
    extends JsonDeserializer<CoinbaseTransactionStatus> {
        private static final EnumFromStringHelper<CoinbaseTransactionStatus> FROM_STRING_HELPER = new EnumFromStringHelper<CoinbaseTransactionStatus>(CoinbaseTransactionStatus.class);

        CoinbaseTransactionStatusDeserializer() {
        }

        public CoinbaseTransactionStatus deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String jsonString = node.textValue();
            return FROM_STRING_HELPER.fromJsonString(jsonString);
        }
    }
}

