/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAccountChanges;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddress;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddressCallback;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddresses;
import org.knowm.xchange.coinbase.dto.account.CoinbaseContacts;
import org.knowm.xchange.coinbase.dto.account.CoinbaseRecurringPayment;
import org.knowm.xchange.coinbase.dto.account.CoinbaseRecurringPayments;
import org.knowm.xchange.coinbase.dto.account.CoinbaseTransaction;
import org.knowm.xchange.coinbase.dto.account.CoinbaseTransactions;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUsers;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButton;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseOrder;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseOrders;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseSubscription;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseSubscriptions;
import org.knowm.xchange.coinbase.service.CoinbaseBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

class CoinbaseAccountServiceRaw
extends CoinbaseBaseService {
    public CoinbaseAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinbaseUsers getCoinbaseUsers() throws IOException {
        CoinbaseUsers users = this.coinbase.getUsers(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return users;
    }

    public CoinbaseUser updateCoinbaseUser(CoinbaseUser user) throws IOException {
        CoinbaseUser updatedUser = this.coinbase.updateUser(user.getId(), user, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(updatedUser);
    }

    public boolean redeemCoinbaseToken(String tokenId) throws IOException {
        CoinbaseBaseResponse response = this.coinbase.redeemToken(tokenId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(response).isSuccess();
    }

    public CoinbaseMoney getCoinbaseBalance() throws IOException {
        CoinbaseMoney balance = this.coinbase.getBalance(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return balance;
    }

    public CoinbaseAddress getCoinbaseReceiveAddress() throws IOException {
        CoinbaseAddress receiveResult = this.coinbase.getReceiveAddress(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return receiveResult;
    }

    public CoinbaseAddresses getCoinbaseAddresses() throws IOException {
        return this.getCoinbaseAddresses(null, null, null);
    }

    public CoinbaseAddresses getCoinbaseAddresses(Integer page, Integer limit, String filter) throws IOException {
        CoinbaseAddresses receiveResult = this.coinbase.getAddresses(page, limit, filter, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return receiveResult;
    }

    public CoinbaseAddress generateCoinbaseReceiveAddress() throws IOException {
        return this.generateCoinbaseReceiveAddress(null, null);
    }

    public CoinbaseAddress generateCoinbaseReceiveAddress(String callbackUrl, String label) throws IOException {
        CoinbaseAddressCallback callbackUrlParam = new CoinbaseAddressCallback(callbackUrl, label);
        CoinbaseAddress generateReceiveAddress = this.coinbase.generateReceiveAddress(callbackUrlParam, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(generateReceiveAddress);
    }

    public CoinbaseAccountChanges getCoinbaseAccountChanges() throws IOException {
        return this.getCoinbaseAccountChanges(null);
    }

    public CoinbaseAccountChanges getCoinbaseAccountChanges(Integer page) throws IOException {
        CoinbaseAccountChanges accountChanges = this.coinbase.getAccountChanges(page, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return accountChanges;
    }

    public CoinbaseContacts getCoinbaseContacts() throws IOException {
        return this.getCoinbaseContacts(null, null, null);
    }

    public CoinbaseContacts getCoinbaseContacts(Integer page, Integer limit, String filter) throws IOException {
        CoinbaseContacts contacts = this.coinbase.getContacts(page, limit, filter, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return contacts;
    }

    public CoinbaseTransactions getCoinbaseTransactions() throws IOException {
        return this.getCoinbaseTransactions(null);
    }

    public CoinbaseTransactions getCoinbaseTransactions(Integer page) throws IOException {
        CoinbaseTransactions transactions = this.coinbase.getTransactions(page, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return transactions;
    }

    public CoinbaseTransaction getCoinbaseTransaction(String transactionIdOrIdemField) throws IOException {
        CoinbaseTransaction transaction = this.coinbase.getTransactionDetails(transactionIdOrIdemField, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(transaction);
    }

    public CoinbaseTransaction requestMoneyCoinbaseRequest(CoinbaseTransaction.CoinbaseRequestMoneyRequest transactionRequest) throws IOException {
        CoinbaseTransaction pendingTransaction = this.coinbase.requestMoney(new CoinbaseTransaction(transactionRequest), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(pendingTransaction);
    }

    public CoinbaseTransaction sendMoneyCoinbaseRequest(CoinbaseTransaction.CoinbaseSendMoneyRequest transactionRequest) throws IOException {
        CoinbaseTransaction pendingTransaction = this.coinbase.sendMoney(new CoinbaseTransaction(transactionRequest), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(pendingTransaction);
    }

    public CoinbaseBaseResponse resendCoinbaseRequest(String transactionId) throws IOException {
        CoinbaseBaseResponse response = this.coinbase.resendRequest(transactionId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(response);
    }

    public CoinbaseTransaction completeCoinbaseRequest(String transactionId) throws IOException {
        CoinbaseTransaction response = this.coinbase.completeRequest(transactionId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(response);
    }

    public CoinbaseBaseResponse cancelCoinbaseRequest(String transactionId) throws IOException {
        CoinbaseBaseResponse response = this.coinbase.cancelRequest(transactionId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(response);
    }

    public CoinbaseButton createCoinbaseButton(CoinbaseButton button) throws IOException {
        CoinbaseButton createdButton = this.coinbase.createButton(button, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(createdButton);
    }

    public CoinbaseOrders getCoinbaseOrders() throws IOException {
        return this.getCoinbaseOrders(null);
    }

    public CoinbaseOrders getCoinbaseOrders(Integer page) throws IOException {
        CoinbaseOrders orders = this.coinbase.getOrders(page, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return orders;
    }

    public CoinbaseOrder getCoinbaseOrder(String orderIdOrCustom) throws IOException {
        CoinbaseOrder order = this.coinbase.getOrder(orderIdOrCustom, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(order);
    }

    public CoinbaseOrder createCoinbaseOrder(String code) throws IOException {
        CoinbaseOrder createdOrder = this.coinbase.createOrder(code, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(createdOrder);
    }

    public CoinbaseOrder createCoinbaseOrder(CoinbaseButton button) throws IOException {
        CoinbaseOrder createdOrder = this.coinbase.createOrder(button, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(createdOrder);
    }

    public CoinbaseRecurringPayments getCoinbaseRecurringPayments() throws IOException {
        return this.getCoinbaseRecurringPayments(null, null);
    }

    public CoinbaseRecurringPayments getCoinbaseRecurringPayments(Integer page, Integer limit) throws IOException {
        CoinbaseRecurringPayments recurringPayments = this.coinbase.getRecurringPayments(page, limit, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return recurringPayments;
    }

    public CoinbaseRecurringPayment getCoinbaseRecurringPayment(String recurringPaymentId) throws IOException {
        CoinbaseRecurringPayment recurringPayment = this.coinbase.getRecurringPayment(recurringPaymentId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return recurringPayment;
    }

    public CoinbaseSubscriptions getCoinbaseSubscriptions() throws IOException {
        return this.getCoinbaseSubscriptions(null, null);
    }

    public CoinbaseSubscriptions getCoinbaseSubscriptions(Integer page, Integer limit) throws IOException {
        CoinbaseSubscriptions subscriptions = this.coinbase.getsSubscriptions(page, limit, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return subscriptions;
    }

    public CoinbaseSubscription getCoinbaseSubscription(String subscriptionId) throws IOException {
        CoinbaseSubscription subscription = this.coinbase.getsSubscription(subscriptionId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return subscription;
    }
}

