/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbasePagedResult;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddress;
import org.knowm.xchange.utils.DateUtils;

@JsonDeserialize(using=CoinbaseAddressesDeserializer.class)
public class CoinbaseAddresses
extends CoinbasePagedResult {
    private final List<CoinbaseAddress> addresses;

    private CoinbaseAddresses(@JsonProperty(value="addresses") List<CoinbaseAddress> addresses, @JsonProperty(value="total_count") int totalCount, @JsonProperty(value="num_pages") int numPages, @JsonProperty(value="current_page") int currentPage) {
        super(totalCount, numPages, currentPage);
        this.addresses = addresses;
    }

    public List<CoinbaseAddress> getAddresses() {
        return this.addresses;
    }

    @Override
    public String toString() {
        return "CoinbaseAddresses [addresses=" + this.addresses + "]";
    }

    static class CoinbaseAddressesDeserializer
    extends JsonDeserializer<CoinbaseAddresses> {
        CoinbaseAddressesDeserializer() {
        }

        public CoinbaseAddresses deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode addressesArrayNode = node.path("addresses");
            ArrayList<CoinbaseAddress> addresses = new ArrayList<CoinbaseAddress>();
            for (JsonNode addressNode : addressesArrayNode) {
                addresses.add(this.getAddressFromNode(addressNode));
            }
            int totalCount = node.path("total_count").asInt();
            int numPages = node.path("num_pages").asInt();
            int currentPage = node.path("current_page").asInt();
            return new CoinbaseAddresses(addresses, totalCount, numPages, currentPage);
        }

        private CoinbaseAddress getAddressFromNode(JsonNode addressNode) throws InvalidFormatException {
            JsonNode nestedAddressNode = addressNode.path("address");
            String address = nestedAddressNode.path("address").asText();
            String callbackUrl = nestedAddressNode.path("callback_url").asText();
            String label = nestedAddressNode.path("label").asText();
            Date createdAt = DateUtils.fromISO8601DateString((String)nestedAddressNode.path("created_at").asText());
            return new CoinbaseAddress(address, callbackUrl, label, createdAt);
        }
    }
}

