/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseMoneyDeserializer;

@JsonDeserialize(using=CoibasePriceDeserializer.class)
public class CoinbasePrice {
    private final CoinbaseMoney coinbaseFee;
    private final CoinbaseMoney bankFee;
    private final CoinbaseMoney total;
    private final CoinbaseMoney subTotal;

    private CoinbasePrice(CoinbaseMoney coinbaseFee, CoinbaseMoney bankFee, CoinbaseMoney total, CoinbaseMoney subTotal) {
        this.coinbaseFee = coinbaseFee;
        this.bankFee = bankFee;
        this.total = total;
        this.subTotal = subTotal;
    }

    public CoinbaseMoney getCoinbaseFee() {
        return this.coinbaseFee;
    }

    public CoinbaseMoney getBankFee() {
        return this.bankFee;
    }

    public CoinbaseMoney getTotal() {
        return this.total;
    }

    public CoinbaseMoney getSubTotal() {
        return this.subTotal;
    }

    public String toString() {
        return "CoinbasePrice [coinbaseFee=" + this.coinbaseFee + ", bankFee=" + this.bankFee + ", total=" + this.total + ", subTotal=" + this.subTotal + "]";
    }

    static class CoibasePriceDeserializer
    extends JsonDeserializer<CoinbasePrice> {
        CoibasePriceDeserializer() {
        }

        public CoinbasePrice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            CoinbaseMoney subTotal = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(node.path("subtotal"));
            JsonNode feesNode = node.path("fees");
            CoinbaseMoney coinbaseFee = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(feesNode.path(0).path("coinbase"));
            CoinbaseMoney bankFee = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(feesNode.path(1).path("bank"));
            CoinbaseMoney total = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(node.path("total"));
            return new CoinbasePrice(coinbaseFee, bankFee, total, subTotal);
        }
    }
}

