/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.coinbase.v2.Coinbase;
import org.knowm.xchange.coinbase.v2.CoinbaseV2Digest;
import org.knowm.xchange.coinbase.v2.dto.CoinbaseException;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseAccountData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseAccountsData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseBuyData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbasePaymentMethodsData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseSellData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseTransactionsResponse;
import org.knowm.xchange.coinbase.v2.dto.account.transactions.CoinbaseBuySellResponse;
import si.mazi.rescu.ParamsDigest;

@Path(value="/v2")
@Produces(value={"application/json"})
public interface CoinbaseAuthenticated
extends Coinbase {
    public static final String CB_ACCESS_KEY = "CB-ACCESS-KEY";
    public static final String CB_ACCESS_SIGN = "CB-ACCESS-SIGN";
    public static final String CB_ACCESS_TIMESTAMP = "CB-ACCESS-TIMESTAMP";
    public static final String CONTENT_TYPE = "Content-Type";

    @GET
    @Path(value="accounts/{accountId}/transactions")
    public CoinbaseTransactionsResponse getTransactions(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="accountId") String var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts/{accountId}/buys")
    public CoinbaseBuySellResponse getBuys(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") CoinbaseV2Digest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="accountId") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="starting_after") String var7) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts/{accountId}/sells")
    public CoinbaseBuySellResponse getSells(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") CoinbaseV2Digest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="accountId") String var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="starting_after") String var7) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts/{accountId}/deposits")
    public Map getDeposits(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="accountId") String var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts/{accountId}/withdrawals")
    public Map getWithdrawals(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="accountId") String var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts")
    public CoinbaseAccountsData getAccounts(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="accounts/{currency}")
    public CoinbaseAccountData getAccount(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") CoinbaseV2Digest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4, @PathParam(value="currency") String var5) throws IOException, CoinbaseException;

    @POST
    @Path(value="accounts")
    @Consumes(value={"application/json"})
    public CoinbaseAccountData createAccount(@HeaderParam(value="Content-Type") String var1, @HeaderParam(value="CB-VERSION") String var2, @HeaderParam(value="CB-ACCESS-KEY") String var3, @HeaderParam(value="CB-ACCESS-SIGN") String var4, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var5, Object var6) throws IOException, CoinbaseException;

    @GET
    @Path(value="payment-methods")
    public CoinbasePaymentMethodsData getPaymentMethods(@HeaderParam(value="CB-VERSION") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") CoinbaseV2Digest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="accounts/{account}/buys")
    @Consumes(value={"application/json"})
    public CoinbaseBuyData buy(@HeaderParam(value="Content-Type") String var1, @HeaderParam(value="CB-VERSION") String var2, @HeaderParam(value="CB-ACCESS-KEY") String var3, @HeaderParam(value="CB-ACCESS-SIGN") String var4, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var5, @PathParam(value="account") String var6, Object var7) throws IOException, CoinbaseException;

    @POST
    @Path(value="accounts/{account}/sells")
    @Consumes(value={"application/json"})
    public CoinbaseSellData sell(@HeaderParam(value="Content-Type") String var1, @HeaderParam(value="CB-VERSION") String var2, @HeaderParam(value="CB-ACCESS-KEY") String var3, @HeaderParam(value="CB-ACCESS-SIGN") String var4, @HeaderParam(value="CB-ACCESS-TIMESTAMP") BigDecimal var5, @PathParam(value="account") String var6, Object var7) throws IOException, CoinbaseException;
}

