/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseAccountData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbasePaymentMethodsData;
import org.knowm.xchange.coinbase.v2.dto.account.CoinbaseTransactionsResponse;
import org.knowm.xchange.coinbase.v2.service.CoinbaseBaseService;
import org.knowm.xchange.currency.Currency;
import si.mazi.rescu.ParamsDigest;

public class CoinbaseAccountServiceRaw
extends CoinbaseBaseService {
    public CoinbaseAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinbaseTransactionsResponse getTransactions(String accountId) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getTransactions("2018-04-08", apiKey, (ParamsDigest)this.signatureCreator2, timestamp, accountId);
    }

    public Map getDeposits(String accountId) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getDeposits("2018-04-08", apiKey, (ParamsDigest)this.signatureCreator2, timestamp, accountId);
    }

    public Map getWithdrawals(String accountId) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getWithdrawals("2018-04-08", apiKey, (ParamsDigest)this.signatureCreator2, timestamp, accountId);
    }

    public List<CoinbaseAccountData.CoinbaseAccount> getCoinbaseAccounts() throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getAccounts("2018-04-08", apiKey, (ParamsDigest)this.signatureCreator2, timestamp).getData();
    }

    public CoinbaseAccountData.CoinbaseAccount getCoinbaseAccount(Currency currency) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getAccount("2018-04-08", apiKey, this.signatureCreator2, timestamp, currency.getCurrencyCode()).getData();
    }

    public CoinbaseAccountData.CoinbaseAccount createCoinbaseAccount(String name) throws IOException {
        CreateCoinbaseAccountPayload payload = new CreateCoinbaseAccountPayload(name);
        String path = "/v2/accounts";
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        String body = new ObjectMapper().writeValueAsString((Object)payload);
        String signature = this.getSignature(timestamp, CoinbaseBaseService.HttpMethod.POST, path, body);
        this.showCurl(CoinbaseBaseService.HttpMethod.POST, apiKey, timestamp, signature, path, body);
        return this.coinbase.createAccount("application/json", "2018-04-08", apiKey, signature, timestamp, payload).getData();
    }

    public List<CoinbasePaymentMethodsData.CoinbasePaymentMethod> getCoinbasePaymentMethods() throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        return this.coinbase.getPaymentMethods("2018-04-08", apiKey, this.signatureCreator2, timestamp).getData();
    }

    public static class CreateCoinbaseAccountPayload {
        @JsonProperty
        String name;

        CreateCoinbaseAccountPayload(String name) {
            this.name = name;
        }
    }
}

