/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceOrder;

public class CoinbaseProPlaceMarketOrder
extends CoinbaseProPlaceOrder {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="size")
    BigDecimal size;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="funds")
    BigDecimal funds;

    public CoinbaseProPlaceMarketOrder(String clientOld, CoinbaseProPlaceOrder.Type type, CoinbaseProPlaceOrder.Side side, String productId, CoinbaseProPlaceOrder.SelfTradePrevention stp, CoinbaseProPlaceOrder.Stop stop, BigDecimal stopPrice, BigDecimal size, BigDecimal funds) {
        super(clientOld, type, side, productId, stp, stop, stopPrice);
        this.size = size;
        this.funds = funds;
        if (size != null && funds != null || size == null && funds == null) {
            throw new IllegalArgumentException("One of size or funds is required.");
        }
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public BigDecimal getFunds() {
        return this.funds;
    }

    public String toString() {
        return "CoinbaseProPlaceMarketOrder [size=" + this.size + ", funds=" + this.funds + ", clientOid=" + this.clientOid + ", type=" + (Object)((Object)this.type) + ", side=" + (Object)((Object)this.side) + ", productId=" + this.productId + ", stp=" + (Object)((Object)this.stp) + ", stop=" + (Object)((Object)this.stop) + ", stopPrice=" + this.stopPrice + "]";
    }

    public static class Builder
    extends CoinbaseProPlaceOrder.Builder<CoinbaseProPlaceMarketOrder, Builder> {
        BigDecimal size;
        BigDecimal funds;

        public Builder size(BigDecimal size) {
            this.size = size;
            return this;
        }

        public Builder funds(BigDecimal funds) {
            this.funds = funds;
            return this;
        }

        @Override
        public CoinbaseProPlaceMarketOrder build() {
            return new CoinbaseProPlaceMarketOrder(this.clientOid, this.type, this.side, this.productId, this.stp, this.stop, this.stopPrice, this.size, this.funds);
        }
    }
}

