/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro;

import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.vavr.control.Either;
import java.time.Duration;
import javax.ws.rs.core.Response;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.client.ResilienceUtils;

public class CoinbaseProResilience {
    public static final String PUBLIC_REST_ENDPOINT_RATE_LIMITER = "publicEndpointLimit";
    public static final String PRIVATE_REST_ENDPOINT_RATE_LIMITER = "privateEndpointLimit";

    public static ResilienceRegistries createRegistries() {
        ResilienceRegistries registries = new ResilienceRegistries();
        registries.rateLimiters().rateLimiter(PUBLIC_REST_ENDPOINT_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(10).drainPermissionsOnResult(e -> ResilienceUtils.matchesHttpCode((Either)e, (Response.Status)Response.Status.TOO_MANY_REQUESTS)).build());
        registries.rateLimiters().rateLimiter(PRIVATE_REST_ENDPOINT_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(15).drainPermissionsOnResult(e -> ResilienceUtils.matchesHttpCode((Either)e, (Response.Status)Response.Status.TOO_MANY_REQUESTS)).build());
        return registries;
    }
}

