/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProException;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTrades;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTransfers;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProFee;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProSendMoneyRequest;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWithdrawCryptoResponse;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWithdrawFundsRequest;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCandle;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCurrency;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProduct;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBook;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductTicker;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProTrade;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccount;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccountAddress;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProFill;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProIdResponse;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProSendMoneyResponse;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.HttpStatusIOException;
import si.mazi.rescu.ParamsDigest;

@Path(value="/")
@Produces(value={"application/json"})
public interface CoinbasePro {
    @GET
    @Path(value="currencies")
    public CoinbaseProCurrency[] getCurrencies() throws CoinbaseProException, IOException;

    @GET
    @Path(value="products")
    public CoinbaseProProduct[] getProducts() throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/ticker")
    public CoinbaseProProductTicker getProductTicker(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2) throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/stats")
    public CoinbaseProProductStats getProductStats(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2) throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/stats")
    public Map<String, CoinbaseProStats> getStats() throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/book?level={level}")
    public CoinbaseProProductBook getProductOrderBook(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2, @PathParam(value="level") String var3) throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/trades")
    public CoinbaseProTrade[] getTrades(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2) throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/trades")
    public CoinbaseProTrades getTradesPageable(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2, @QueryParam(value="after") Long var3, @QueryParam(value="limit") Integer var4) throws CoinbaseProException, IOException;

    @GET
    @Path(value="products/{baseCurrency}-{targetCurrency}/candles")
    public CoinbaseProCandle[] getHistoricalCandles(@PathParam(value="baseCurrency") String var1, @PathParam(value="targetCurrency") String var2, @QueryParam(value="start") String var3, @QueryParam(value="end") String var4, @QueryParam(value="granularity") String var5) throws CoinbaseProException, IOException;

    @GET
    @Path(value="accounts")
    public org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount[] getAccounts(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5) throws CoinbaseProException, IOException;

    @GET
    @Path(value="fees")
    public CoinbaseProFee getFees(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5) throws CoinbaseProException, IOException;

    @GET
    @Path(value="orders")
    public CoinbaseProOrder[] getListOrders(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5) throws CoinbaseProException, IOException;

    @GET
    @Path(value="orders?status={status}")
    public CoinbaseProOrder[] getListOrders(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @PathParam(value="status") String var6) throws CoinbaseProException, IOException;

    @POST
    @Path(value="orders")
    @Consumes(value={"application/json"})
    public CoinbaseProIdResponse placeOrder(CoinbaseProPlaceOrder var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var4, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var6) throws CoinbaseProException, IOException;

    @DELETE
    @Path(value="orders/{id}")
    @Produces(value={"text/plain"})
    public void cancelOrder(@PathParam(value="id") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var4, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var6) throws CoinbaseProException, IOException;

    @GET
    @Path(value="orders/{id}")
    @Produces(value={"application/json"})
    public CoinbaseProOrder getOrder(@PathParam(value="id") String var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var4, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var6) throws CoinbaseProException, IOException;

    @GET
    @Path(value="fills")
    public CoinbaseProFill[] getFills(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @QueryParam(value="after") Integer var6, @QueryParam(value="before") Integer var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="order_id") String var9, @QueryParam(value="product_id") String var10) throws CoinbaseProException, IOException;

    @POST
    @Path(value="accounts/{account_id}/transactions")
    @Consumes(value={"application/json"})
    public CoinbaseProSendMoneyResponse sendMoney(CoinbaseProSendMoneyRequest var1, @HeaderParam(value="CB-ACCESS-KEY") String var2, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var3, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var4, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var6, @PathParam(value="account_id") String var7) throws CoinbaseProException, IOException;

    @GET
    @Path(value="accounts/{account_id}/ledger")
    @Consumes(value={"application/json"})
    public List<Map<?, ?>> ledger(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @PathParam(value="account_id") String var6, @QueryParam(value="after") Integer var7) throws CoinbaseProException, IOException;

    @GET
    @Path(value="accounts/{account_id}/transfers")
    @Consumes(value={"application/json"})
    public CoinbaseProTransfers transfers(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @PathParam(value="account_id") String var6, @QueryParam(value="profile_id") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="after") String var9);

    @GET
    @Path(value="transfers")
    @Consumes(value={"application/json"})
    public CoinbaseProTransfers transfers(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @QueryParam(value="type") String var6, @QueryParam(value="profile_id") String var7, @QueryParam(value="before") String var8, @QueryParam(value="after") String var9, @QueryParam(value="limit") Integer var10);

    @POST
    @Path(value="reports")
    @Consumes(value={"application/json"})
    public Map<?, ?> createReport(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, CoinbaseProReportRequest var6) throws CoinbaseProException, IOException;

    @GET
    @Path(value="reports/{report_id}")
    @Consumes(value={"application/json"})
    public Map<?, ?> getReport(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @PathParam(value="report_id") String var6) throws CoinbaseProException, IOException;

    @POST
    @Path(value="withdrawals/crypto")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CoinbaseProWithdrawCryptoResponse withdrawCrypto(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, CoinbaseProWithdrawFundsRequest var6) throws HttpStatusIOException;

    @GET
    @Path(value="coinbase-accounts")
    public CoinbaseProAccount[] getCoinbaseProAccounts(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5) throws HttpStatusIOException;

    @POST
    @Path(value="coinbase-accounts/{account_id}/addresses")
    public CoinbaseProAccountAddress getCoinbaseProAccountAddress(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5, @PathParam(value="account_id") String var6);

    @GET
    @Path(value="/users/self/verify")
    public JsonNode getVerifyId(@HeaderParam(value="CB-ACCESS-KEY") String var1, @HeaderParam(value="CB-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="CB-ACCESS-TIMESTAMP") long var3, @HeaderParam(value="CB-ACCESS-PASSPHRASE") String var5) throws CoinbaseProException, IOException;

    public static class CoinbaseProReportRequest {
        @JsonProperty(value="type")
        public final String type;
        @JsonProperty(value="start_date")
        public final String startDate;
        @JsonProperty(value="end_date")
        public final String endDate;
        @JsonProperty(value="product_id")
        public final String productId;
        @JsonProperty(value="account_id")
        public final String accountId;
        @JsonProperty(value="format")
        public final String format;
        @JsonProperty(value="email")
        public final String email;

        public CoinbaseProReportRequest(Type type, Date startDate, Date endDate, String productId, String accountId, Format format, String email) {
            this(type.name(), DateUtils.toUTCString((Date)startDate), DateUtils.toUTCString((Date)endDate), productId, accountId, format == null ? null : format.name(), email);
        }

        public CoinbaseProReportRequest(String type, String startDate, String endDate, String productId, String accountId, String format, String email) {
            this.type = type;
            this.startDate = startDate;
            this.endDate = endDate;
            this.productId = productId;
            this.accountId = accountId;
            this.format = format;
            this.email = email;
        }

        public static enum Type {
            fills,
            account;

        }

        public static enum Format {
            pdf,
            csv;

        }
    }
}

