/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbaseProAdapters;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTransfer;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTransfers;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProFee;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccount;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccountAddress;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProSendMoneyResponse;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProTradeHistoryParams;
import org.knowm.xchange.coinbasepro.service.CoinbaseProAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class CoinbaseProAccountService
extends CoinbaseProAccountServiceRaw
implements AccountService {
    public CoinbaseProAccountService(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{CoinbaseProAdapters.adaptAccountInfo(this.getCoinbaseProAccountInfo())});
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        CoinbaseProFee fees = this.getCoinbaseProFees();
        HashMap<CurrencyPair, Fee> tradingFees = new HashMap<CurrencyPair, Fee>();
        List pairs = ((CoinbaseProExchange)this.exchange).getExchangeSymbols();
        pairs.forEach(pair -> tradingFees.put((CurrencyPair)pair, new Fee(fees.getMakerRate(), fees.getTakerRate())));
        return tradingFees;
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, AddressWithTag address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawCrypto((String)defaultParams.getAddress(), (BigDecimal)defaultParams.getAmount(), (Currency)defaultParams.getCurrency(), (String)defaultParams.getAddressTag(), (boolean)(defaultParams.getAddressTag() == null ? true : false)).id;
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String moveFunds(Currency currency, String address, BigDecimal amount) throws IOException {
        org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount[] accounts = this.getCoinbaseProAccountInfo();
        String accountId = null;
        for (org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount account : accounts) {
            if (!currency.getCurrencyCode().equals(account.getCurrency())) continue;
            accountId = account.getId();
        }
        if (accountId == null) {
            throw new ExchangeException("Cannot determine account id for currency " + currency.getCurrencyCode());
        }
        CoinbaseProSendMoneyResponse response = this.sendMoney(accountId, address, amount, currency);
        if (response.getData() != null) {
            return response.getData().getId();
        }
        return null;
    }

    private CoinbaseProAccountAddress accountAddress(Currency currency, String ... args) throws IOException {
        CoinbaseProAccount[] coinbaseAccounts = this.getCoinbaseAccounts();
        CoinbaseProAccount depositAccount = null;
        for (CoinbaseProAccount account : coinbaseAccounts) {
            Currency accountCurrency = Currency.getInstance((String)account.getCurrency());
            if (!account.isActive() || !"wallet".equals(account.getType()) || !accountCurrency.equals((Object)currency)) continue;
            depositAccount = account;
            break;
        }
        return this.getCoinbaseAccountAddress(depositAccount.getId());
    }

    @Deprecated
    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.accountAddress(currency, args).getAddress();
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        CoinbaseProAccountAddress depositAddress = this.accountAddress(currency, args);
        return new AddressWithTag(depositAddress.getAddress(), depositAddress.getDestinationTag());
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new CoinbaseProTradeHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        if (!(params instanceof HistoryParamsFundingType) || ((HistoryParamsFundingType)params).getType() == null) {
            throw new ExchangeException("Type 'deposit' or 'withdraw' must be supplied using FundingRecord.Type");
        }
        FundingRecord.Type type = ((HistoryParamsFundingType)params).getType();
        String fundingRecordType = type == FundingRecord.Type.WITHDRAWAL ? "withdraw" : "deposit";
        int maxPageSize = 100;
        ArrayList<FundingRecord> fundingHistory = new ArrayList<FundingRecord>();
        Map<String, String> accountToCurrencyMap = Stream.of(this.getCoinbaseProAccountInfo()).collect(Collectors.toMap(org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount::getId, org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount::getCurrency));
        String createdAt = null;
        while (true) {
            String createdAtFinal = createdAt;
            CoinbaseProTransfers transfers = this.transfers(fundingRecordType, null, null, createdAtFinal, maxPageSize);
            for (CoinbaseProTransfer coinbaseProTransfer : transfers) {
                Currency currency = Currency.getInstance((String)accountToCurrencyMap.get(coinbaseProTransfer.getAccountId()));
                fundingHistory.add(CoinbaseProAdapters.adaptFundingRecord(currency, coinbaseProTransfer));
            }
            if (transfers.size() < maxPageSize) break;
            createdAt = transfers.getHeader("Cb-After");
        }
        return fundingHistory;
    }

    public static class CoinbaseProMoveFundsParams
    implements WithdrawFundsParams {
        public final Currency currency;
        public final BigDecimal amount;
        public final String address;

        public CoinbaseProMoveFundsParams(Currency currency, BigDecimal amount, String address) {
            this.currency = currency;
            this.amount = amount;
            this.address = address;
        }
    }
}

