/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coingi.CoingiAuthenticated;
import org.knowm.xchange.coingi.dto.account.CoingiBalanceRequest;
import org.knowm.xchange.coingi.dto.account.CoingiBalances;
import org.knowm.xchange.coingi.dto.account.CoingiDepositWalletRequest;
import org.knowm.xchange.coingi.dto.account.CoingiDepositWalletResponse;
import org.knowm.xchange.coingi.dto.account.CoingiUserTransactionList;
import org.knowm.xchange.coingi.dto.account.CoingiWithdrawalRequest;
import org.knowm.xchange.coingi.dto.account.CoingiWithdrawalResponse;
import org.knowm.xchange.coingi.dto.trade.CoingiTransactionHistoryRequest;
import org.knowm.xchange.coingi.service.CoingiBaseService;
import org.knowm.xchange.coingi.service.CoingiDigest;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class CoingiAccountServiceRaw
extends CoingiBaseService {
    private final CoingiAuthenticated coingiAuthenticated;

    protected CoingiAccountServiceRaw(Exchange exchange) {
        super(exchange);
        ClientConfig clientConfig = this.getClientConfig();
        this.coingiAuthenticated = (CoingiAuthenticated)RestProxyFactory.createProxy(CoingiAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)clientConfig, (Interceptor[])new Interceptor[0]);
        String apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = CoingiDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), apiKey);
    }

    public CoingiBalances getCoingiBalance() throws IOException {
        CoingiBalanceRequest balanceRequest = new CoingiBalanceRequest();
        this.handleAuthentication(balanceRequest);
        balanceRequest.setCurrencies("btc,ltc,ppc,doge,vtc,nmc,dash,usd,eur,czk");
        return this.coingiAuthenticated.getUserBalance(balanceRequest);
    }

    public CoingiUserTransactionList getTransactions(CoingiTransactionHistoryRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.getTransactionHistory(request);
    }

    public CoingiWithdrawalResponse withdraw(CoingiWithdrawalRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.createWithdrawal(request);
    }

    public CoingiDepositWalletResponse depositWallet(CoingiDepositWalletRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.depositWallet(request);
    }
}

