/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coingi.CoingiAuthenticated;
import org.knowm.xchange.coingi.dto.trade.CoingiCancelOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderHistoryRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiOrder;
import org.knowm.xchange.coingi.dto.trade.CoingiOrdersList;
import org.knowm.xchange.coingi.dto.trade.CoingiPlaceLimitOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiPlaceOrderResponse;
import org.knowm.xchange.coingi.service.CoingiBaseService;
import org.knowm.xchange.coingi.service.CoingiDigest;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class CoingiTradeServiceRaw
extends CoingiBaseService {
    private final CoingiAuthenticated coingiAuthenticated;

    public CoingiTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.coingiAuthenticated = (CoingiAuthenticated)RestProxyFactory.createProxy(CoingiAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        String apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = CoingiDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), apiKey);
    }

    public CoingiPlaceOrderResponse placeCoingiLimitOrder(CoingiPlaceLimitOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.placeLimitOrder(request);
    }

    public CoingiOrder cancelCoingiOrder(CoingiCancelOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.cancelOrder(request);
    }

    public CoingiOrder getCoingiOrder(CoingiGetOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.getOrderStatus(request);
    }

    public CoingiOrdersList getCoingiOrderHistory(CoingiGetOrderHistoryRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.getOrderHistory(request);
    }
}

