/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.coingi.dto.account.CoingiBalance;
import org.knowm.xchange.coingi.dto.account.CoingiBalances;
import org.knowm.xchange.coingi.dto.account.CoingiUserTransaction;
import org.knowm.xchange.coingi.dto.marketdata.CoingiOrderBook;
import org.knowm.xchange.coingi.dto.marketdata.CoingiOrderGroup;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTicker;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTransaction;
import org.knowm.xchange.coingi.dto.trade.CoingiOrder;
import org.knowm.xchange.coingi.dto.trade.CoingiOrdersList;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;

public final class CoingiAdapters {
    private CoingiAdapters() {
    }

    public static AccountInfo adaptAccountInfo(CoingiBalances coingiBalances, String userName) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (CoingiBalance coingiBalance : coingiBalances.getList()) {
            BigDecimal total = coingiBalance.getAvailable().add(coingiBalance.getBlocked()).add(coingiBalance.getWithdrawing()).add(coingiBalance.getDeposited());
            Balance xchangeBalance = new Balance(Currency.getInstance((String)coingiBalance.getCurrency().getName().toUpperCase()), total, coingiBalance.getAvailable(), coingiBalance.getBlocked(), BigDecimal.ZERO, BigDecimal.ZERO, coingiBalance.getWithdrawing(), coingiBalance.getDeposited());
            balances.add(xchangeBalance);
        }
        return new AccountInfo(userName, new Wallet[]{Wallet.Builder.from(balances).build()});
    }

    public static OrderBook adaptOrderBook(CoingiOrderBook coingiOrderBook) {
        List<BigDecimal> priceAndAmount;
        ArrayList<LimitOrder> asks = new ArrayList<LimitOrder>();
        ArrayList<LimitOrder> bids = new ArrayList<LimitOrder>();
        for (CoingiOrderGroup ask : coingiOrderBook.getAsks()) {
            priceAndAmount = Arrays.asList(ask.getPrice(), ask.getBaseAmount());
            LimitOrder askLimit = CoingiAdapters.createOrder(CoingiAdapters.adaptCurrency(ask.getCurrencyPair()), priceAndAmount, CoingiAdapters.adaptOrderType(ask.getType()));
            askLimit.setOrderStatus(CoingiAdapters.adaptOrderStatus(0));
            asks.add(askLimit);
        }
        for (CoingiOrderGroup bid : coingiOrderBook.getBids()) {
            priceAndAmount = Arrays.asList(bid.getPrice(), bid.getBaseAmount());
            LimitOrder bidLimit = CoingiAdapters.createOrder(CoingiAdapters.adaptCurrency(bid.getCurrencyPair()), priceAndAmount, CoingiAdapters.adaptOrderType(bid.getType()));
            bidLimit.setOrderStatus(CoingiAdapters.adaptOrderStatus(0));
            bids.add(bidLimit);
        }
        return new OrderBook(null, asks, bids);
    }

    public static Order.OrderType adaptOrderType(int type) {
        return type == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static CurrencyPair adaptCurrency(Map<String, String> currencyPair) {
        String baseCurrency = currencyPair.get("base");
        String counterCurrency = currencyPair.get("counter");
        return new CurrencyPair(baseCurrency, counterCurrency);
    }

    public static String adaptCurrency(CurrencyPair pair) {
        return pair.toString().replace('/', '-').toLowerCase();
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            CoingiAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(CoingiAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), (Instrument)currencyPair, "", null, priceAndAmount.get(0));
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static OpenOrders adaptOpenOrders(CoingiOrdersList orders) {
        ArrayList<LimitOrder> list = new ArrayList<LimitOrder>();
        for (CoingiOrder order : orders) {
            LimitOrder limitOrder = new LimitOrder(order.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK, order.getOriginalBaseAmount(), (Instrument)CoingiAdapters.adaptCurrency(order.getCurrencyPair()), order.getId(), new Date(order.getTimestamp()), order.getPrice());
            limitOrder.setOrderStatus(CoingiAdapters.adaptOrderStatus(order.getStatus()));
            list.add(limitOrder);
        }
        return new OpenOrders(list);
    }

    public static Trade adaptTrade(CoingiUserTransaction tx, CurrencyPair currencyPair, int timeScale) {
        Order.OrderType orderType = tx.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradeId = tx.getId();
        Date date = DateUtils.fromMillisUtc((long)(tx.getTimestamp() * (long)timeScale));
        return new Trade.Builder().type(orderType).originalAmount(tx.getBaseAmount()).currencyPair(currencyPair).price(tx.getPrice()).timestamp(date).id(tradeId).build();
    }

    public static Trade adaptTrade(CoingiTransaction tx, CurrencyPair currencyPair, int timeScale) {
        Order.OrderType orderType = tx.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradeId = tx.getId();
        Date date = new Date(tx.getTimestamp());
        return new Trade.Builder().type(orderType).originalAmount(tx.getAmount()).currencyPair(currencyPair).price(tx.getPrice()).timestamp(date).id(tradeId).build();
    }

    public static UserTrades adaptTradeHistory(CoingiOrdersList ordersList) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (CoingiOrder o : ordersList.getList()) {
            Order.OrderType orderType = o.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
            CurrencyPair pair = new CurrencyPair(o.getCurrencyPair().get("base").toUpperCase(), o.getCurrencyPair().get("counter").toUpperCase());
            UserTrade trade = new UserTrade.Builder().type(orderType).originalAmount(o.getOriginalBaseAmount()).currencyPair(pair).price(o.getPrice()).timestamp(new Date(o.getTimestamp())).id(o.getId()).orderId(o.getId()).feeAmount(BigDecimal.ZERO).build();
            trades.add(trade);
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByID);
    }

    public static Trades adaptTrades(List<CoingiTransaction> coingiTransactions, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = System.currentTimeMillis() / 1000L;
        for (int i = 0; i < coingiTransactions.size(); ++i) {
            CoingiTransaction tx = coingiTransactions.get(i);
            trades.add(CoingiAdapters.adaptTrade(tx, currencyPair, 1000));
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Order.OrderStatus adaptOrderStatus(int status) {
        if (status == 0) {
            return Order.OrderStatus.PENDING_NEW;
        }
        if (status == 1) {
            return Order.OrderStatus.PARTIALLY_FILLED;
        }
        if (status == 2) {
            return Order.OrderStatus.FILLED;
        }
        if (status == 3) {
            return Order.OrderStatus.CANCELED;
        }
        if (status == 4) {
            return Order.OrderStatus.PENDING_CANCEL;
        }
        throw new NotYetImplementedForExchangeException();
    }

    public static Ticker adaptTicker(List<CoingiTicker> tickers, OrderBook orderBook, CurrencyPair currencyPair) {
        CoingiAdapters.checkArgument(tickers != null && tickers.size() == 1, "Expected a list of 1 ticker but got {0}", tickers == null ? null : Integer.valueOf(tickers.size()));
        return new Ticker.Builder().currencyPair(currencyPair).open(tickers.get(0).getOpen()).last(tickers.get(0).getClose()).high(tickers.get(0).getHigh()).low(tickers.get(0).getLow()).vwap(tickers.get(0).getVwap()).volume(tickers.get(0).getVolume()).timestamp(CoingiAdapters.getTimestamp(tickers)).bid(CoingiAdapters.getBid(orderBook)).ask(CoingiAdapters.getAsk(orderBook)).build();
    }

    private static Date getTimestamp(List<CoingiTicker> tickers) {
        if (tickers.get(0).getTimestamp() == null) {
            return null;
        }
        return new Date(tickers.get(0).getTimestamp() * 1000L);
    }

    private static BigDecimal getAsk(OrderBook orderBook) {
        return orderBook.getAsks().stream().map(LimitOrder::getLimitPrice).sorted(Comparator.naturalOrder()).findFirst().orElse(null);
    }

    private static BigDecimal getBid(OrderBook orderBook) {
        return orderBook.getBids().stream().map(LimitOrder::getLimitPrice).sorted(Comparator.reverseOrder()).findFirst().orElse(null);
    }
}

