/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.coingi.Coingi;
import org.knowm.xchange.coingi.CoingiAdapters;
import org.knowm.xchange.coingi.dto.marketdata.CoingiOrderBook;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTicker;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTransaction;
import org.knowm.xchange.coingi.service.CoingiBaseService;
import org.knowm.xchange.currency.CurrencyPair;

public class CoingiMarketDataServiceRaw
extends CoingiBaseService {
    private final Coingi coingi;

    protected CoingiMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.coingi = (Coingi)ExchangeRestProxyBuilder.forInterface(Coingi.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public CoingiOrderBook getCoingiOrderBook(CurrencyPair currencyPair, int maxAskCount, int maxBidCount, int maxDepthRangeCount) throws IOException {
        return this.coingi.getOrderBook(CoingiAdapters.adaptCurrency(currencyPair), maxAskCount, maxBidCount, maxDepthRangeCount);
    }

    public List<CoingiTransaction> getTransactions(CurrencyPair currencyPair, int maxCount) throws IOException {
        return this.coingi.getTransaction(CoingiAdapters.adaptCurrency(currencyPair), maxCount);
    }

    public List<CoingiTicker> getTickers(CurrencyPair currencyPair, Integer aggregationIntervalSize, int maxCount) throws IOException {
        return this.coingi.getTicker(CoingiAdapters.adaptCurrency(currencyPair), aggregationIntervalSize, maxCount);
    }
}

