/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.coingi.CoingiAuthenticated;
import org.knowm.xchange.coingi.dto.trade.CoingiCancelOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderHistoryRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiOrder;
import org.knowm.xchange.coingi.dto.trade.CoingiOrdersList;
import org.knowm.xchange.coingi.dto.trade.CoingiPlaceLimitOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiPlaceOrderResponse;
import org.knowm.xchange.coingi.service.CoingiBaseService;
import org.knowm.xchange.coingi.service.CoingiDigest;

public class CoingiTradeServiceRaw
extends CoingiBaseService {
    private final CoingiAuthenticated coingiAuthenticated;

    public CoingiTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.coingiAuthenticated = (CoingiAuthenticated)ExchangeRestProxyBuilder.forInterface(CoingiAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        String apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = CoingiDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), apiKey);
    }

    public CoingiPlaceOrderResponse placeCoingiLimitOrder(CoingiPlaceLimitOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.placeLimitOrder(request);
    }

    public CoingiOrder cancelCoingiOrder(CoingiCancelOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.cancelOrder(request);
    }

    public CoingiOrder getCoingiOrder(CoingiGetOrderRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.getOrderStatus(request);
    }

    public CoingiOrdersList getCoingiOrderHistory(CoingiGetOrderHistoryRequest request) throws IOException {
        this.handleAuthentication(request);
        return this.coingiAuthenticated.getOrderHistory(request);
    }
}

