/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinmate.CoinmateException;
import org.knowm.xchange.coinmate.CoinmateUtils;
import org.knowm.xchange.coinmate.dto.account.CoinmateBalance;
import org.knowm.xchange.coinmate.dto.account.CoinmateBalanceData;
import org.knowm.xchange.coinmate.dto.account.CoinmateBalanceDataEntry;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateOrderBook;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateOrderBookData;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateOrderBookEntry;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTicker;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTickerData;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTransactions;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTransactionsData;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTransactionsEntry;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrders;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrdersData;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrdersEntry;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeHistory;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeHistoryEntry;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistory;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistoryData;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistoryEntry;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;

public class CoinmateAdapters {
    public static Ticker adaptTicker(CoinmateTicker coinmateTicker, CurrencyPair currencyPair) {
        BigDecimal last = ((CoinmateTickerData)coinmateTicker.getData()).getLast();
        BigDecimal bid = ((CoinmateTickerData)coinmateTicker.getData()).getBid();
        BigDecimal ask = ((CoinmateTickerData)coinmateTicker.getData()).getAsk();
        BigDecimal high = ((CoinmateTickerData)coinmateTicker.getData()).getHigh();
        BigDecimal low = ((CoinmateTickerData)coinmateTicker.getData()).getLow();
        BigDecimal volume = ((CoinmateTickerData)coinmateTicker.getData()).getAmount();
        Date timestamp = new Date(((CoinmateTickerData)coinmateTicker.getData()).getTimestamp() * 1000L);
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    public static List<LimitOrder> createOrders(List<CoinmateOrderBookEntry> coinmateOrders, Order.OrderType type, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>(coinmateOrders.size());
        for (CoinmateOrderBookEntry entry : coinmateOrders) {
            LimitOrder order = new LimitOrder(type, entry.getAmount(), currencyPair, null, null, entry.getPrice());
            orders.add(order);
        }
        return orders;
    }

    public static OrderBook adaptOrderBook(CoinmateOrderBook coinmateOrderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = CoinmateAdapters.createOrders(((CoinmateOrderBookData)coinmateOrderBook.getData()).getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = CoinmateAdapters.createOrders(((CoinmateOrderBookData)coinmateOrderBook.getData()).getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    public static Trades adaptTrades(CoinmateTransactions coinmateTransactions) {
        ArrayList<Trade> trades = new ArrayList<Trade>(((CoinmateTransactionsData)coinmateTransactions.getData()).size());
        for (CoinmateTransactionsEntry coinmateEntry : (CoinmateTransactionsData)coinmateTransactions.getData()) {
            Trade trade = CoinmateAdapters.adaptTrade(coinmateEntry);
            trades.add(trade);
        }
        return new Trades(trades, Trades.TradeSortType.SortByID);
    }

    public static Trade adaptTrade(CoinmateTransactionsEntry coinmateEntry) {
        return new Trade.Builder().originalAmount(coinmateEntry.getAmount()).currencyPair(CoinmateUtils.getPair(coinmateEntry.getCurrencyPair())).price(coinmateEntry.getPrice()).timestamp(new Date(coinmateEntry.getTimestamp())).id(coinmateEntry.getTransactionId()).build();
    }

    public static Wallet adaptWallet(CoinmateBalance coinmateBalance) {
        CoinmateBalanceData funds = (CoinmateBalanceData)coinmateBalance.getData();
        ArrayList<Balance> balances = new ArrayList<Balance>(funds.size());
        for (String lcCurrency : funds.keySet()) {
            Currency currency = Currency.getInstance((String)lcCurrency.toUpperCase());
            Balance balance = new Balance(currency, ((CoinmateBalanceDataEntry)funds.get(lcCurrency)).getBalance(), ((CoinmateBalanceDataEntry)funds.get(lcCurrency)).getAvailable(), ((CoinmateBalanceDataEntry)funds.get(lcCurrency)).getReserved());
            balances.add(balance);
        }
        return Wallet.Builder.from(balances).build();
    }

    public static UserTrades adaptTransactionHistory(CoinmateTransactionHistory coinmateTradeHistory) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(((CoinmateTransactionHistoryData)coinmateTradeHistory.getData()).size());
        block10: for (CoinmateTransactionHistoryEntry entry : (CoinmateTransactionHistoryData)coinmateTradeHistory.getData()) {
            Order.OrderType orderType;
            String transactionType;
            switch (transactionType = entry.getTransactionType()) {
                case "BUY": 
                case "QUICK_BUY": {
                    orderType = Order.OrderType.BID;
                    break;
                }
                case "SELL": 
                case "QUICK_SELL": {
                    orderType = Order.OrderType.ASK;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            UserTrade trade = new UserTrade.Builder().type(orderType).originalAmount(entry.getAmount()).currencyPair(CoinmateUtils.getPair(entry.getAmountCurrency() + "_" + entry.getPriceCurrency())).price(entry.getPrice()).timestamp(new Date(entry.getTimestamp())).id(Long.toString(entry.getTransactionId())).orderId(Long.toString(entry.getOrderId())).feeAmount(entry.getFee()).feeCurrency(Currency.getInstance((String)entry.getFeeCurrency())).build();
            trades.add(trade);
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrades adaptTradeHistory(CoinmateTradeHistory coinmateTradeHistory) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(((ArrayList)coinmateTradeHistory.getData()).size());
        block10: for (CoinmateTradeHistoryEntry entry : (ArrayList)coinmateTradeHistory.getData()) {
            Order.OrderType orderType;
            String transactionType;
            switch (transactionType = entry.getType()) {
                case "BUY": 
                case "QUICK_BUY": {
                    orderType = Order.OrderType.BID;
                    break;
                }
                case "SELL": 
                case "QUICK_SELL": {
                    orderType = Order.OrderType.ASK;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            UserTrade trade = new UserTrade.Builder().type(orderType).originalAmount(entry.getAmount()).currencyPair(CoinmateUtils.getPair(entry.getCurrencyPair())).price(entry.getPrice()).timestamp(new Date(entry.getCreatedTimestamp())).id(Long.toString(entry.getTransactionId())).orderId(Long.toString(entry.getOrderId())).feeAmount(entry.getFee()).feeCurrency(CoinmateUtils.getPair((String)entry.getCurrencyPair()).counter).build();
            trades.add(trade);
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static List<FundingRecord> adaptFundingHistory(CoinmateTransactionHistory coinmateTradeHistory) {
        ArrayList<FundingRecord> fundings = new ArrayList<FundingRecord>();
        block25: for (CoinmateTransactionHistoryEntry entry : (CoinmateTransactionHistoryData)coinmateTradeHistory.getData()) {
            FundingRecord.Status status;
            FundingRecord.Type type;
            switch (entry.getTransactionType()) {
                case "WITHDRAWAL": 
                case "CREATE_VOUCHER": {
                    type = FundingRecord.Type.WITHDRAWAL;
                    break;
                }
                case "DEPOSIT": 
                case "USED_VOUCHER": 
                case "NEW_USER_REWARD": 
                case "REFERRAL": {
                    type = FundingRecord.Type.DEPOSIT;
                    break;
                }
                default: {
                    continue block25;
                }
            }
            switch (entry.getStatus().toUpperCase()) {
                case "OK": 
                case "COMPLETED": {
                    status = FundingRecord.Status.COMPLETE;
                    break;
                }
                case "NEW": 
                case "SENT": 
                case "CREATED": 
                case "WAITING": 
                case "PENDING": {
                    status = FundingRecord.Status.PROCESSING;
                    break;
                }
                default: {
                    status = FundingRecord.Status.FAILED;
                }
            }
            String transactionId = Long.toString(entry.getTransactionId());
            String description = entry.getDescription();
            String feeCurrency = entry.getFeeCurrency();
            String externalId = null;
            if (entry.getTransactionType().equals("DEPOSIT") && description.startsWith(feeCurrency + ": ")) {
                externalId = description.replace(feeCurrency + ": ", "");
            }
            FundingRecord funding = new FundingRecord(null, new Date(entry.getTimestamp()), Currency.getInstance((String)entry.getAmountCurrency()), entry.getAmount(), transactionId, externalId, type, status, null, entry.getFee(), description);
            fundings.add(funding);
        }
        return fundings;
    }

    public static List<LimitOrder> adaptOpenOrders(CoinmateOpenOrders coinmateOpenOrders) throws CoinmateException {
        ArrayList<LimitOrder> ordersList = new ArrayList<LimitOrder>(((CoinmateOpenOrdersData)coinmateOpenOrders.getData()).size());
        for (CoinmateOpenOrdersEntry entry : (CoinmateOpenOrdersData)coinmateOpenOrders.getData()) {
            Order.OrderType orderType;
            if ("BUY".equals(entry.getType())) {
                orderType = Order.OrderType.BID;
            } else if ("SELL".equals(entry.getType())) {
                orderType = Order.OrderType.ASK;
            } else {
                throw new CoinmateException("Unknown order type");
            }
            LimitOrder limitOrder = new LimitOrder(orderType, entry.getAmount(), CoinmateUtils.getPair(entry.getCurrencyPair()), Long.toString(entry.getId()), new Date(entry.getTimestamp()), entry.getPrice());
            ordersList.add(limitOrder);
        }
        return ordersList;
    }

    public static String adaptSortOrder(TradeHistoryParamsSorted.Order order) {
        switch (order) {
            case asc: {
                return "ASC";
            }
            case desc: {
                return "DESC";
            }
        }
        throw new IllegalArgumentException();
    }
}

