/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.coinmate.service.CoinmateAccountService;
import org.knowm.xchange.coinmate.service.CoinmateMarketDataService;
import org.knowm.xchange.coinmate.service.CoinmateMetadataServiceRaw;
import org.knowm.xchange.coinmate.service.CoinmateTradeService;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.nonce.AtomicLongCurrentTimeIncrementalNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class CoinmateExchange
extends BaseExchange
implements Exchange {
    private final SynchronizedValueFactory<Long> nonceFactory = new AtomicLongCurrentTimeIncrementalNonceFactory();

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    protected void initServices() {
        this.marketDataService = new CoinmateMarketDataService(this);
        this.accountService = new CoinmateAccountService(this);
        this.tradeService = new CoinmateTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://coinmate.io");
        exchangeSpecification.setHost("coinmate.io");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("CoinMate");
        exchangeSpecification.setExchangeDescription("Bitcoin trading made simple.");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException, ExchangeException {
        CoinmateMetadataServiceRaw metadataService = new CoinmateMetadataServiceRaw(this);
        this.exchangeMetaData = metadataService.getMetadata();
    }
}

