/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAdapters;
import org.knowm.xchange.coinmate.dto.account.CoinmateDepositAddresses;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistory;
import org.knowm.xchange.coinmate.service.CoinmateAccountServiceRaw;
import org.knowm.xchange.coinmate.service.CoinmateTradeService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class CoinmateAccountService
extends CoinmateAccountServiceRaw
implements AccountService {
    public static final int DEFAULT_RESULT_LIMIT = 100;

    public CoinmateAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{CoinmateAdapters.adaptWallet(this.getCoinmateBalance())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response;
        if (currency.equals((Object)Currency.BTC)) {
            response = this.coinmateBitcoinWithdrawal(amount, address);
        } else if (currency.equals((Object)Currency.LTC)) {
            response = this.coinmateLitecoinWithdrawal(amount, address);
        } else if (currency.equals((Object)Currency.BCH)) {
            response = this.coinmateBitcoinCashWithdrawal(amount, address);
        } else if (currency.equals((Object)Currency.ETH)) {
            response = this.coinmateEthereumWithdrawal(amount, address);
        } else if (currency.equals((Object)Currency.XRP)) {
            response = this.coinmateRippleWithdrawal(amount, address);
        } else if (currency.equals((Object)Currency.DASH)) {
            response = this.coinmateDashWithdrawal(amount, address);
        } else {
            throw new IOException("Wallet for currency" + currency.getCurrencyCode() + " is currently not supported");
        }
        return Long.toString((Long)response.getData());
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        CoinmateDepositAddresses addresses;
        if (currency.equals((Object)Currency.BTC)) {
            addresses = this.coinmateBitcoinDepositAddresses();
        } else if (currency.equals((Object)Currency.LTC)) {
            addresses = this.coinmateLitecoinDepositAddresses();
        } else if (currency.equals((Object)Currency.BCH)) {
            addresses = this.coinmateBitcoinCashDepositAddresses();
        } else if (currency.equals((Object)Currency.ETH)) {
            addresses = this.coinmateEthereumDepositAddresses();
        } else if (currency.equals((Object)Currency.XRP)) {
            addresses = this.coinmateRippleDepositAddresses();
        } else if (currency.equals((Object)Currency.DASH)) {
            addresses = this.coinmateDashDepositAddresses();
        } else {
            throw new IOException("Wallet for currency" + currency.getCurrencyCode() + " is currently not supported");
        }
        if (((ArrayList)addresses.getData()).isEmpty()) {
            return null;
        }
        return (String)((ArrayList)addresses.getData()).get(0);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new CoinmateFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        TradeHistoryParamsSorted.Order order = TradeHistoryParamsSorted.Order.asc;
        Integer limit = 1000;
        int offset = 0;
        if (params instanceof TradeHistoryParamOffset) {
            offset = Math.toIntExact(((TradeHistoryParamOffset)params).getOffset());
        }
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        if (params instanceof TradeHistoryParamsSorted) {
            order = ((TradeHistoryParamsSorted)params).getOrder();
        }
        CoinmateTransactionHistory coinmateTransactionHistory = this.getCoinmateTransactionHistory(offset, limit, CoinmateAdapters.adaptSortOrder(order));
        return CoinmateAdapters.adaptFundingHistory(coinmateTransactionHistory);
    }

    public static class CoinmateFundingHistoryParams
    extends CoinmateTradeService.CoinmateTradeHistoryHistoryParams {
    }
}

