/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAuthenticated;
import org.knowm.xchange.coinmate.dto.account.CoinmateBalance;
import org.knowm.xchange.coinmate.dto.account.CoinmateDepositAddresses;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTransactionHistory;
import org.knowm.xchange.coinmate.service.CoinmateBaseService;
import org.knowm.xchange.coinmate.service.CoinmateDigest;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class CoinmateAccountServiceRaw
extends CoinmateBaseService {
    private final CoinmateDigest signatureCreator;
    private final CoinmateAuthenticated coinmateAuthenticated;

    public CoinmateAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.coinmateAuthenticated = (CoinmateAuthenticated)RestProxyFactory.createProxy(CoinmateAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.signatureCreator = CoinmateDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), exchange.getExchangeSpecification().getApiKey());
    }

    public CoinmateBalance getCoinmateBalance() throws IOException {
        CoinmateBalance coinmateBalance = this.coinmateAuthenticated.getBalances(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(coinmateBalance);
        return coinmateBalance;
    }

    public CoinmateTradeResponse coinmateBitcoinWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.bitcoinWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateBitcoinDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.bitcoinDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTradeResponse coinmateLitecoinWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.litecoinWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateLitecoinDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.litecoinDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTradeResponse coinmateBitcoinCashWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.bitcoinCashWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateBitcoinCashDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.bitcoinCashDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTradeResponse coinmateEthereumWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.ethereumWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateEthereumDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.ethereumDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTradeResponse coinmateRippleWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.rippleWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateRippleDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.rippleDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTradeResponse coinmateDashWithdrawal(BigDecimal amount, String address) throws IOException {
        CoinmateTradeResponse response = this.coinmateAuthenticated.dashWithdrawal(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        CoinmateAccountServiceRaw.throwExceptionIfError(response);
        return response;
    }

    public CoinmateDepositAddresses coinmateDashDepositAddresses() throws IOException {
        CoinmateDepositAddresses addresses = this.coinmateAuthenticated.dashDepositAddresses(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        CoinmateAccountServiceRaw.throwExceptionIfError(addresses);
        return addresses;
    }

    public CoinmateTransactionHistory getCoinmateTransactionHistory(int offset, Integer limit, String sort) throws IOException {
        CoinmateTransactionHistory tradeHistory = this.coinmateAuthenticated.getTransactionHistory(this.exchange.getExchangeSpecification().getApiKey(), this.exchange.getExchangeSpecification().getUserName(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), offset, limit, sort);
        CoinmateAccountServiceRaw.throwExceptionIfError(tradeHistory);
        return tradeHistory;
    }
}

