/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.Coinmate;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateOrderBook;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTicker;
import org.knowm.xchange.coinmate.dto.marketdata.CoinmateTransactions;
import org.knowm.xchange.coinmate.service.CoinmateBaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class CoinmateMarketDataServiceRaw
extends CoinmateBaseService {
    private final Coinmate coinmate;

    public CoinmateMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.coinmate = (Coinmate)RestProxyFactory.createProxy(Coinmate.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
    }

    public CoinmateTicker getCoinmateTicker(String currencyPair) throws IOException {
        CoinmateTicker ticker = this.coinmate.getTicker(currencyPair);
        CoinmateMarketDataServiceRaw.throwExceptionIfError(ticker);
        return ticker;
    }

    public CoinmateOrderBook getCoinmateOrderBook(String currencyPair, boolean groupByPriceLimit) throws IOException {
        CoinmateOrderBook orderBook = this.coinmate.getOrderBook(currencyPair, groupByPriceLimit);
        CoinmateMarketDataServiceRaw.throwExceptionIfError(orderBook);
        return orderBook;
    }

    public CoinmateTransactions getCoinmateTransactions(int minutesIntoHistory, String currencyPair) throws IOException {
        CoinmateTransactions transactions = this.coinmate.getTransactions(minutesIntoHistory, currencyPair);
        CoinmateMarketDataServiceRaw.throwExceptionIfError(transactions);
        return transactions;
    }
}

