/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinmate.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinmate.CoinmateAdapters;
import org.knowm.xchange.coinmate.CoinmateException;
import org.knowm.xchange.coinmate.CoinmateUtils;
import org.knowm.xchange.coinmate.dto.trade.CoinmateCancelOrderResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOpenOrders;
import org.knowm.xchange.coinmate.dto.trade.CoinmateOrderFlags;
import org.knowm.xchange.coinmate.dto.trade.CoinmateReplaceResponse;
import org.knowm.xchange.coinmate.dto.trade.CoinmateReplaceResponseData;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeHistory;
import org.knowm.xchange.coinmate.dto.trade.CoinmateTradeResponse;
import org.knowm.xchange.coinmate.service.CoinmateOpenOrdersParams;
import org.knowm.xchange.coinmate.service.CoinmateTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class CoinmateTradeService
extends CoinmateTradeServiceRaw
implements TradeService {
    public CoinmateTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders((OpenOrdersParams)this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        CurrencyPair currencyPair = null;
        if (params instanceof OpenOrdersParamCurrencyPair) {
            currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        }
        String currencyPairString = CoinmateUtils.getPair(currencyPair);
        CoinmateOpenOrders coinmateOpenOrders = this.getCoinmateOpenOrders(currencyPairString);
        List<LimitOrder> orders = CoinmateAdapters.adaptOpenOrders(coinmateOpenOrders);
        return new OpenOrders(orders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        CoinmateTradeResponse response;
        if (marketOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.sellCoinmateInstant(marketOrder.getOriginalAmount(), CoinmateUtils.getPair(marketOrder.getCurrencyPair()));
        } else if (marketOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.buyCoinmateInstant(marketOrder.getOriginalAmount(), CoinmateUtils.getPair(marketOrder.getCurrencyPair()));
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString((Long)response.getData());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        CoinmateTradeResponse response;
        boolean hidden = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.HIDDEN);
        boolean immediateOrCancel = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.IMMEDIATE_OR_CANCEL);
        boolean trailing = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.TRAILING);
        if (limitOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.sellCoinmateLimit(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()), null, hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else if (limitOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.buyCoinmateLimit(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()), null, hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString((Long)response.getData());
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        CoinmateTradeResponse response;
        boolean hidden = stopOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.HIDDEN);
        boolean immediateOrCancel = stopOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.IMMEDIATE_OR_CANCEL);
        boolean trailing = stopOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.TRAILING);
        if (stopOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.sellCoinmateLimit(stopOrder.getOriginalAmount(), stopOrder.getLimitPrice(), CoinmateUtils.getPair(stopOrder.getCurrencyPair()), stopOrder.getStopPrice(), hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else if (stopOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.buyCoinmateLimit(stopOrder.getOriginalAmount(), stopOrder.getLimitPrice(), CoinmateUtils.getPair(stopOrder.getCurrencyPair()), stopOrder.getStopPrice(), hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString((Long)response.getData());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        CoinmateCancelOrderResponse response = this.cancelCoinmateOrder(orderId);
        return (Boolean)response.getData();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        TradeHistoryParamsSorted.Order order = TradeHistoryParamsSorted.Order.asc;
        Integer limit = 1000;
        int offset = 0;
        CurrencyPair currencyPair = null;
        if (params instanceof TradeHistoryParamOffset) {
            offset = Math.toIntExact(((TradeHistoryParamOffset)params).getOffset());
        }
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        if (params instanceof TradeHistoryParamsSorted) {
            order = ((TradeHistoryParamsSorted)params).getOrder();
        }
        if (params instanceof TradeHistoryParamCurrencyPair) {
            currencyPair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        }
        CoinmateTradeHistory coinmateTradeHistory = this.getCoinmateTradeHistory(CoinmateUtils.getPair(currencyPair), limit, CoinmateAdapters.adaptSortOrder(order));
        return CoinmateAdapters.adaptTradeHistory(coinmateTradeHistory);
    }

    public String changeOrder(LimitOrder limitOrder) throws IOException {
        CoinmateReplaceResponse response;
        boolean hidden = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.HIDDEN);
        boolean immediateOrCancel = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.IMMEDIATE_OR_CANCEL);
        boolean trailing = limitOrder.getOrderFlags().contains((Object)CoinmateOrderFlags.TRAILING);
        if (limitOrder.getType().equals((Object)Order.OrderType.ASK)) {
            response = this.coinmateReplaceBySellLimit(limitOrder.getId(), limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()), null, hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else if (limitOrder.getType().equals((Object)Order.OrderType.BID)) {
            response = this.coinmateReplaceByBuyLimit(limitOrder.getId(), limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), CoinmateUtils.getPair(limitOrder.getCurrencyPair()), null, hidden ? 1 : 0, immediateOrCancel ? 1 : 0, trailing ? 1 : 0);
        } else {
            throw new CoinmateException("Unknown order type");
        }
        return Long.toString(((CoinmateReplaceResponseData)response.getData()).getCreatedOrderId());
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new CoinmateTradeHistoryHistoryParams();
    }

    public CoinmateOpenOrdersParams createOpenOrdersParams() {
        return new CoinmateOpenOrdersParams();
    }

    public static class CoinmateTradeHistoryHistoryParams
    implements TradeHistoryParamOffset,
    TradeHistoryParamLimit,
    TradeHistoryParamsSorted {
        private Integer limit;
        private Long offset;
        private TradeHistoryParamsSorted.Order order;

        public CoinmateTradeHistoryHistoryParams(Integer limit, Long offset, TradeHistoryParamsSorted.Order order) {
            this.limit = limit;
            this.offset = offset;
            this.order = order;
        }

        public CoinmateTradeHistoryHistoryParams() {
            this(100, 0L, TradeHistoryParamsSorted.Order.asc);
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public Long getOffset() {
            return this.offset;
        }

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public TradeHistoryParamsSorted.Order getOrder() {
            return this.order;
        }

        public void setOrder(TradeHistoryParamsSorted.Order order) {
            this.order = order;
        }
    }
}

