/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.enigma.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.enigma.EnigmaAuthenticated;
import org.knowm.xchange.enigma.dto.account.EnigmaCredentials;
import org.knowm.xchange.enigma.dto.account.EnigmaLoginResponse;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public abstract class EnigmaBaseService
extends BaseExchangeService
implements BaseService {
    protected final EnigmaAuthenticated enigmaAuthenticated;
    protected final SynchronizedValueFactory<Long> nonceFactory;

    protected EnigmaBaseService(Exchange exchange) {
        super(exchange);
        this.enigmaAuthenticated = (EnigmaAuthenticated)RestProxyFactory.createProxy(EnigmaAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public void login() throws IOException {
        ExchangeSpecification currentSpec = this.exchange.getExchangeSpecification();
        String username = currentSpec.getUserName();
        String password = currentSpec.getPassword();
        EnigmaLoginResponse loginResponse = this.enigmaAuthenticated.login(new EnigmaCredentials(username, password));
        currentSpec.setApiKey(loginResponse.getKey());
        this.exchange.applySpecification(currentSpec);
    }

    protected String accessToken() {
        return this.exchange.getExchangeSpecification().getApiKey();
    }
}

