/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ftx;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.ftx.FtxException;
import org.knowm.xchange.ftx.dto.FtxResponse;
import org.knowm.xchange.ftx.dto.marketdata.FtxCandleDto;
import org.knowm.xchange.ftx.dto.marketdata.FtxMarketDto;
import org.knowm.xchange.ftx.dto.marketdata.FtxMarketsDto;
import org.knowm.xchange.ftx.dto.marketdata.FtxOrderbookDto;
import org.knowm.xchange.ftx.dto.marketdata.FtxTradeDto;

@Path(value="/api")
@Produces(value={"application/json"})
public interface Ftx {
    @GET
    @Path(value="/markets")
    @Consumes(value={"application/json"})
    public FtxResponse<FtxMarketsDto> getMarkets() throws IOException, FtxException;

    @GET
    @Path(value="/markets/{market_name}")
    @Consumes(value={"application/json"})
    public FtxResponse<FtxMarketDto> getMarket(@PathParam(value="market_name") String var1) throws IOException, FtxException;

    @GET
    @Path(value="/markets/{market_name}/trades")
    @Consumes(value={"application/json"})
    public FtxResponse<List<FtxTradeDto>> getTrades(@PathParam(value="market_name") String var1, @QueryParam(value="limit") int var2) throws IOException, FtxException;

    @GET
    @Path(value="/markets/{market_name}/candles")
    @Consumes(value={"application/json"})
    public FtxResponse<List<FtxCandleDto>> getCandles(@PathParam(value="market_name") String var1, @QueryParam(value="resolution") String var2, @QueryParam(value="start_time") String var3, @QueryParam(value="end_time") String var4, @QueryParam(value="limit") Integer var5) throws IOException, FtxException;

    @GET
    @Path(value="/markets/{market_name}/orderbook")
    public FtxResponse<FtxOrderbookDto> getOrderbook(@PathParam(value="market_name") String var1, @QueryParam(value="depth") int var2) throws IOException, FtxException;
}

