/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ftx;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.ftx.Ftx;
import org.knowm.xchange.ftx.FtxException;
import org.knowm.xchange.ftx.dto.FtxResponse;
import org.knowm.xchange.ftx.dto.account.FtxAccountDto;
import org.knowm.xchange.ftx.dto.account.FtxBorrowingHistoryDto;
import org.knowm.xchange.ftx.dto.account.FtxBorrowingInfoDto;
import org.knowm.xchange.ftx.dto.account.FtxBorrowingRatesDto;
import org.knowm.xchange.ftx.dto.account.FtxChangeSubAccountNamePOJO;
import org.knowm.xchange.ftx.dto.account.FtxConvertAcceptPayloadRequestDto;
import org.knowm.xchange.ftx.dto.account.FtxConvertAcceptRequestDto;
import org.knowm.xchange.ftx.dto.account.FtxConvertDto;
import org.knowm.xchange.ftx.dto.account.FtxConvertSimulatePayloadRequestDto;
import org.knowm.xchange.ftx.dto.account.FtxConvertSimulatetDto;
import org.knowm.xchange.ftx.dto.account.FtxFundingPaymentsDto;
import org.knowm.xchange.ftx.dto.account.FtxLendingHistoryDto;
import org.knowm.xchange.ftx.dto.account.FtxLendingInfoDto;
import org.knowm.xchange.ftx.dto.account.FtxLendingRatesDto;
import org.knowm.xchange.ftx.dto.account.FtxLeverageDto;
import org.knowm.xchange.ftx.dto.account.FtxPositionDto;
import org.knowm.xchange.ftx.dto.account.FtxSubAccountBalanceDto;
import org.knowm.xchange.ftx.dto.account.FtxSubAccountDto;
import org.knowm.xchange.ftx.dto.account.FtxSubAccountRequestPOJO;
import org.knowm.xchange.ftx.dto.account.FtxSubAccountTranferDto;
import org.knowm.xchange.ftx.dto.account.FtxSubAccountTransferPOJO;
import org.knowm.xchange.ftx.dto.account.FtxSubmitLendingOfferParams;
import org.knowm.xchange.ftx.dto.account.FtxWalletBalanceDto;
import org.knowm.xchange.ftx.dto.trade.CancelAllFtxOrdersParams;
import org.knowm.xchange.ftx.dto.trade.FtxModifyOrderRequestPayload;
import org.knowm.xchange.ftx.dto.trade.FtxOrderDto;
import org.knowm.xchange.ftx.dto.trade.FtxOrderRequestPayload;
import si.mazi.rescu.ParamsDigest;

@Path(value="/api")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface FtxAuthenticated
extends Ftx {
    @GET
    @Path(value="/account")
    public FtxResponse<FtxAccountDto> getAccountInformation(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @GET
    @Path(value="/wallet/balances")
    public FtxResponse<List<FtxWalletBalanceDto>> getWalletBalances(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @GET
    @Path(value="/positions")
    public FtxResponse<List<FtxPositionDto>> getFtxPositions(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @DELETE
    @Path(value="/subaccounts")
    public FtxResponse deleteSubAccounts(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, FtxSubAccountRequestPOJO var4) throws IOException, FtxException;

    @GET
    @Path(value="/subaccounts")
    public FtxResponse<List<FtxSubAccountDto>> getAllSubAccounts(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3) throws IOException, FtxException;

    @POST
    @Path(value="/subaccounts")
    public FtxResponse<FtxSubAccountDto> createSubAccount(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxSubAccountRequestPOJO var5) throws IOException, FtxException;

    @POST
    @Path(value="/subaccounts/update_name")
    public FtxResponse changeSubAccountName(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, FtxChangeSubAccountNamePOJO var4) throws IOException, FtxException;

    @GET
    @Path(value="/subaccounts/{nickname}/balances")
    public FtxResponse<FtxSubAccountBalanceDto> getSubAccountBalances(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="nickname") String var5) throws IOException, FtxException;

    @POST
    @Path(value="/subaccounts/transfer")
    public FtxResponse<FtxSubAccountTranferDto> transferBetweenSubAccounts(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxSubAccountTransferPOJO var5) throws IOException, FtxException;

    @POST
    @Path(value="/otc/quotes")
    public FtxResponse<FtxConvertSimulatetDto> simulateConvert(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxConvertSimulatePayloadRequestDto var5) throws IOException, FtxException;

    @GET
    @Path(value="/otc/quotes/{quoteId}")
    public FtxResponse<FtxConvertDto> getConvertStatus(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="quoteId") String var5) throws IOException, FtxException;

    @POST
    @Path(value="/otc/quotes/{quoteId}/accept")
    public FtxResponse<FtxConvertAcceptRequestDto> acceptConvert(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="quoteId") String var5, FtxConvertAcceptPayloadRequestDto var6) throws IOException, FtxException;

    @POST
    @Path(value="/orders")
    public FtxResponse<FtxOrderDto> placeOrder(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxOrderRequestPayload var5) throws IOException, FtxException;

    @POST
    @Path(value="/orders/{order_id}/modify")
    public FtxResponse<FtxOrderDto> modifyOrder(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="order_id") String var5, FtxModifyOrderRequestPayload var6) throws IOException, FtxException;

    @POST
    @Path(value="/orders/by_client_id/{client_order_id}/modify")
    public FtxResponse<FtxOrderDto> modifyOrderByClientId(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="client_order_id") String var5, FtxModifyOrderRequestPayload var6) throws IOException, FtxException;

    @GET
    @Path(value="/orders/{order_id}")
    public FtxResponse<FtxOrderDto> getOrderStatus(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="order_id") String var5) throws IOException, FtxException;

    @GET
    @Path(value="/orders?market={market}")
    public FtxResponse<List<FtxOrderDto>> openOrders(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="market") String var5) throws IOException, FtxException;

    @GET
    @Path(value="/orders")
    public FtxResponse<List<FtxOrderDto>> openOrdersWithoutMarket(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @DELETE
    @Path(value="/orders/{orderId}")
    public FtxResponse<String> cancelOrder(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="orderId") String var5) throws IOException, FtxException;

    @DELETE
    @Path(value="/orders")
    public FtxResponse<String> cancelAllOrders(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, CancelAllFtxOrdersParams var5) throws IOException, FtxException;

    @GET
    @Path(value="/orders/history?market={market}")
    public FtxResponse<List<FtxOrderDto>> orderHistory(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="market") String var5) throws IOException, FtxException;

    @DELETE
    @Path(value="/orders/by_client_id/{client_order_id}")
    public FtxResponse<FtxOrderDto> cancelOrderByClientId(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @PathParam(value="client_order_id") String var5) throws IOException, FtxException;

    @POST
    @Path(value="/account/leverage")
    public FtxResponse<FtxLeverageDto> changeLeverage(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxLeverageDto var5) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/borrow_history")
    public FtxResponse<List<FtxBorrowingHistoryDto>> getBorrowHistory(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @QueryParam(value="start_time") Long var5, @QueryParam(value="end_time") Long var6) throws IOException, FtxException;

    @GET
    @Path(value="/funding_payments")
    public FtxResponse<List<FtxFundingPaymentsDto>> getFundingPayments(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, @QueryParam(value="start_time") Long var5, @QueryParam(value="end_time") Long var6, @QueryParam(value="future") String var7) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/lending_info")
    public FtxResponse<List<FtxLendingInfoDto>> getLendingInfos(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/lending_rates")
    public FtxResponse<List<FtxLendingRatesDto>> getLendingRates(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/lending_history")
    public FtxResponse<List<FtxLendingHistoryDto>> getlendingHistories(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;

    @POST
    @Path(value="/spot_margin/offers")
    public FtxResponse submitLendingOffer(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4, FtxSubmitLendingOfferParams var5) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/borrow_rates")
    public FtxResponse<List<FtxBorrowingRatesDto>> getBorrowRates(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3) throws IOException, FtxException;

    @GET
    @Path(value="/spot_margin/borrow_info")
    public FtxResponse<List<FtxBorrowingInfoDto>> getBorrowingInfos(@HeaderParam(value="FTX-KEY") String var1, @HeaderParam(value="FTX-TS") Long var2, @HeaderParam(value="FTX-SIGN") ParamsDigest var3, @HeaderParam(value="FTX-SUBACCOUNT") String var4) throws IOException, FtxException;
}

