/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ftx.service;

import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.ws.rs.HeaderParam;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class FtxDigest
extends BaseParamsDigest {
    private FtxDigest(byte[] secretKey) {
        super(secretKey, "HmacSHA256");
    }

    public static FtxDigest createInstance(String secretKey) {
        if (secretKey != null) {
            return new FtxDigest(secretKey.getBytes());
        }
        return null;
    }

    public String digestParams(RestInvocation restInvocation) {
        String message = restInvocation.getParamValue(HeaderParam.class, "FTX-TS").toString() + restInvocation.getHttpMethod().toUpperCase() + restInvocation.getPath();
        if (!restInvocation.getQueryString().isEmpty()) {
            message = message + "?" + restInvocation.getQueryString();
        }
        if (restInvocation.getHttpMethod().equals("POST") || restInvocation.getPath().contains("/orders") && restInvocation.getHttpMethod().equals("DELETE") && restInvocation.getRequestBody() != null) {
            message = message + restInvocation.getRequestBody();
        }
        Mac mac256 = this.getMac();
        try {
            mac256.update(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new ExchangeException("Digest encoding exception", (Throwable)e);
        }
        return DigestUtils.bytesToHex((byte[])mac256.doFinal()).toLowerCase();
    }
}

