/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ftx.service;

import java.io.IOException;
import java.util.Collection;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.ftx.FtxAdapters;
import org.knowm.xchange.ftx.service.FtxTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByUserReferenceParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class FtxTradeService
extends FtxTradeServiceRaw
implements TradeService {
    public FtxTradeService(Exchange exchange) {
        super(exchange);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeMarketOrderForSubaccount(this.exchange.getExchangeSpecification().getUserName(), marketOrder);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeLimitOrderForSubaccount(this.exchange.getExchangeSpecification().getUserName(), limitOrder);
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        return this.getTradeHistoryForSubaccount(this.exchange.getExchangeSpecification().getUserName(), params);
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelOrderForSubaccount(this.exchange.getExchangeSpecification().getUserName(), orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        return this.cancelOrderForSubaccount(this.exchange.getExchangeSpecification().getUserName(), orderParams);
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByCurrencyPair.class, CancelOrderByUserReferenceParams.class};
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        return this.getOrderFromSubaccount(this.exchange.getExchangeSpecification().getUserName(), orderIds);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        return this.getOpenOrdersForSubaccount(this.exchange.getExchangeSpecification().getUserName(), params);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrdersForSubaccount(this.exchange.getExchangeSpecification().getUserName());
    }

    public OpenPositions getOpenPositions() throws IOException {
        return this.getOpenPositionsForSubaccount(this.exchange.getExchangeSpecification().getUserName());
    }

    public String changeOrder(LimitOrder limitOrder) throws IOException {
        if (limitOrder.getUserReference() != null) {
            return this.modifyFtxOrderByClientId(this.exchange.getExchangeSpecification().getUserName(), limitOrder.getId(), FtxAdapters.adaptModifyOrderToFtxOrderPayload(limitOrder)).getResult().getClientId();
        }
        return this.modifyFtxOrder(this.exchange.getExchangeSpecification().getUserName(), limitOrder.getId(), FtxAdapters.adaptModifyOrderToFtxOrderPayload(limitOrder)).getResult().getId();
    }
}

